#ifndef SOCDAM_H
#define SOCDAM_H


#ifndef M32
#define SOCDAM_BDREGS_MASK  0xFFFFFFFFFFFF0000LLU
#define SOCDAM_BDREGS_BASE  0xFFFFFFFFFFFF0000LLU
#define SOCDAM_BDARGV_BASE  0xFFFFFFFFFFFE0000LLU
#else
#define SOCDAM_BDREGS_MASK    0xFFFF0000U
#define SOCDAM_BDREGS_BASE    0xFFFF0000U
#define SOCDAM_BDARGV_BASE    0xFFFE0000U
#endif


#define SOCDAM_ARGV_BASE 0xFFFE0000  // Read argv from simulator command line from here

#define SOCDAM_REGS_BASE 0xFFFFFF00

#define PID_REG_A        0x10 // Read this address to find CPU core number

#define GETENV_REG       0x20 // Write this address to get a copy of shell environ copied into the emulated memory. (unfinished ?)

#define CMDLINE_ARGC     0x30 // Read argc cmd line arg count.

#define TICKS_REG_A      0x40 // Timer ticks 

#define TRACE_REG_A      0x50 // Tracing flag control

#define PID_REG_B        0x60 // 

#define PID_REG_C        0x70 // 

#define READ_ARGV(X)     ((char **)SOCDAM_ARGV_BASE)

#define READ_ARGC(X)     (((unsigned int  *)(SOCDAM_REGS_BASE + CMDLINE_ARGC))[1]) // Add on 1 owing to big-endian machine.

#define READ_TICKS(X)     (((unsigned int  *)(SOCDAM_REGS_BASE + TICKS_REG_A))[1]) // Add on 1 owing to big-endian machine.

#define READ_PID_REG(X)     (((unsigned int  *)(SOCDAM_REGS_BASE + PID_REG_A))[1]) // Add on 1 owing to big-endian machine.

#define READ_TRACE_REG(X)   (((unsigned int  *)(SOCDAM_REGS_BASE + TRACE_REG_A))[1]) // Add on 1 owing to big-endian machine.

#endif


// Processor cores above one start execution with this...
extern int _extra_cores();
extern int kprintf(const char *, ...);
#ifdef OR1K
#define assert(X) do { if (!(X)) _assert(X, __FILE__, __LINE__); } while (0)
#endif

// eof
