#ifndef ARGV_BACKDOOR_H
#define ARGV_BACKDOOR_H

//
// parzor.h CBG PRAZOR pre-layout power estimation and accounting framework
// $Id: argv_backdoor.h,v 1.2 2011/04/28 11:24:21 djg11 Exp $ 
// (C) 2010 DJ Greaves, University of Cambridge, Computer Laboratory.
//

#include "socdam-bdoor-mapping.h"


class argv_backdoor_setup
{
  unsigned int l, p;
  u64_t a0, a1;
  void put(unsigned int v, u64_t &p)
  {
    assert(p<l);
    argv_ram[p++] = v;
  }

 public:
  int argc1;
  unsigned char *argv_ram;
  unsigned char read(int a) { return argv_ram[a]; }
  u64_t read64(int a) {
    a &= ~7;
    return
      ((u64_t)(argv_ram[a])<<56) |
      ((u64_t)(argv_ram[a+1])<<48) |
      ((u64_t)(argv_ram[a+2])<<40) |
      ((u64_t)(argv_ram[a+3])<<32) |
      ((u64_t)(argv_ram[a+4])<<24) |
       ((u64_t)(argv_ram[a+5])<<16) |
       ((u64_t)(argv_ram[a+6])<<8) |
       ((u64_t)(argv_ram[a+7])<<0);
  }      
  //  char **argv() { return (char **) argv_ram; }
  int argc()  { return argc1; }
 argv_backdoor_setup(const char *image_name, int argc, char *argv[]) : argc1(argc+1)
    {
      l = 65536;
      a0 = 0;
      a1 = 0x100;
      argv_ram = (unsigned char *) malloc(l);
      int d = -1;
      // Copy argv into a packed form in a little RAM to be mapped into backdoor space.
      while (d < argc)
	{
	  assert(a0 < 0x100);       
	  // hmmm assumes 64-bit, big-endian processor - need to fix...
	  u64_t hi = SOCDAM_BDARGV_BASE;
#ifdef TARGET64
	  hi |=  0xFFFFffff00000000LLU;
	  put((a1 | hi)>>56, a0);
	  put((a1 | hi)>>48, a0);
	  put((a1 | hi)>>40, a0);
	  put((a1 | hi)>>32, a0);
#endif
	  put((a1 | hi)>>24, a0);
	  put((a1 | hi)>>16, a0);
	  put((a1 | hi)>>8, a0);
	  put((a1 | hi)>>0, a0);
	  const char *s = (d < 0) ? (d++, image_name): argv[d++];
	  // printf("argc=%i Copying argv string %s to %lx\n", argc1, s, a1);
	  while (*s) put(*s++, a1); 
	  put(*s, a1);
	  assert(a1 < l);
	}
      if (0) for (unsigned int i = 0; i<l;i++) // Do a little printout.
	{
	  printf("%02X ", argv_ram[i]);
	  if ((i &15)==15) printf("\n");
	}
    }
};

extern class argv_backdoor_setup *argv_backdoor_su;

// eof
#endif
