// $Id: main.cpp,v 1.17 2011/07/25 15:34:23 my294 Exp $
// (C) 2009-10 DJ Greaves (TLM 2.0 Version Arturs Prieditis). 
// SoC D/M Classes - CBG Prazor  



#ifdef USE_VERILATED
#include "../verilated/OR1200V.h"
#endif

#ifdef USE_FASTISS
#include "../fastiss/OR1200F.h"
#endif


#include "../bus/busmux64.h"
#include "../memories/sram64_cbg.h"
#include "../io/uart64_cbg.h"
#include <iostream>
#include "csignal"

#ifdef TLM_PO8WER3
#include <tlm_power>
#endif // TLM_POWER3

#define BENCH_CLK_HALFPERIOD 5
#define TIMESCALE_UNIT SC_NS



using namespace std;
using namespace sc_core;
#ifdef TLM_POWER3
using namespace sc_pwr;
#endif // TLM_POWER3


int global_qk_ns = 0;
int g_confidence = 100;
int g_full_traces = false;

tenos_diagnostics_s tenos_diagnostics; // List of callbacks to make under various types of error report.


extern bool g_kill_conf; // TODO delete me
int g_tracelevel = 0;
int g_dcache_tracelevel = 0;
int g_watches = 0;
#define MAXWATCH 32
struct watch_s
{
  u64_t lo;
  u64_t hi;
} Watches[MAXWATCH];
const char *uart_canned_input = 0;
const char *g_name = "noname";
const char *g_vcd_trace_filename = 0;
int n_cores = 1;
int g_harvardf = 0;
int g_dmi_disablef = 1;

sc_trace_file* g_Tf = 0;
int activeWorkers;

#ifdef TLM_POWER3
pw_trace_file* g_vcd_pt = NULL;
pw_trace_file* g_txt_pt = NULL;
pw_trace_file* g_slk_pt = NULL;
#endif // TLM_POWER3


#include "bench1.h" 

argv_backdoor_setup *argv_backdoor_su = 0;

// We may want to stop the processor starting until gdb is connected via RSP.
bool wait_debugger = false; 

bool putchar_backdoor_with_handles = true;

bool use_verilated = false;


class top* the_benchconfig;


// ===========================================================================
void hup_handler(int p_arg)
{
  printf("HUP signal received\n");
  if (the_benchconfig) the_benchconfig->hup_handler(p_arg);
  signal (SIGHUP, hup_handler);
}
// ===========================================================================
void close_simulation(int p_arg)
{
    cout << endl << endl;
    double l_simulation_time = ((double) clock()) / CLOCKS_PER_SEC;

    // Sbenchconfig simulation
    //    sc_sbenchconfig();

#ifdef TLM_POWER3
    if(g_vcd_pt) pw_close_vcd_trace_file(g_vcd_pt);
    if(g_txt_pt) pw_close_txt_trace_file(g_txt_pt);
    if(g_slk_pt) pw_close_slk_trace_file(g_slk_pt);
#endif // TLM_POWER3

//    if(the_benchconfig != NULL)
//        delete the_benchconfig;

    if(p_arg == 0)
        cout << endl << endl
             << "[INFO] End of Simulation" << endl;
    else
        cout << endl << endl
             << "[INFO] Simulation Interrupted" << endl;

    cout << " \t- Simulation Time: " << sc_time_stamp() << endl
 //        << " \t- Transaction Completed: " << g_transaction_nb << endl
 //        << " \t- Transaction/Sec: "
 //        << g_transaction_nb / l_simulation_time << endl
         << " \t- Simulation Duration: " << l_simulation_time << " sec"
         << endl;

    exit(0);
}




int sc_main(int argc, char* argv[])
{

  const char *image_lo = "image.out";
  const char *image_hi = 0;

  const char *device_ini = 0;
  const char *system_ini = 0;

  signal(SIGINT, close_simulation);

  signal(SIGHUP, hup_handler);


  while (argc > 1)
    {
      if (!strcmp(argv[1], "-kill-conf")) // Debugging
	{
	  POWER3(g_kill_conf = 1);
	  argc -= 1; argv += 1;
	  continue;
	}
      else if (!strcmp(argv[1], "-dmi-disable")) // Disable backdoor access to RAMs.
	{
	  g_dmi_disablef = 1;
	  argc -= 1; argv += 1;
	  continue;
	}
      else if (!strcmp(argv[1], "-dmi-enable")) 
	{
	  g_dmi_disablef = 0;
	  argc -= 1; argv += 1;
	  continue;
	}
      else if (!strcmp(argv[1], "-harvard")) // Have separate I+D caches
	{
	  g_harvardf = 1;
	  argc -= 1; argv += 1;
	  continue;
	}
      else if (!strcmp(argv[1], "-full-traces"))
	{
	  g_full_traces = 1;
	  argc -= 1; argv += 1;
	  continue;
	}
      else if (!strcmp(argv[1], "-cores"))
	{
	  n_cores = atoi(argv[2]);
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (!strcmp(argv[1], "-global-qk-ns"))
	{
	  global_qk_ns = atoi(argv[2]);
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (!strcmp(argv[1], "-tracelevel"))
	{
	  g_tracelevel = atoi(argv[2]);
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (!strcmp(argv[1], "-dcache-tracelevel"))
	{
	  g_dcache_tracelevel = atoi(argv[2]);
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (!strcmp(argv[1], "-watch"))
	{ 
	  u64_t lo, hi;
	  int c = sscanf(argv[2], "%lx", &lo);
	  if (argv[3][0] == '+') // +n for second value is a relative offset.
	    {
	      c += sscanf(argv[3]+1, "%lx", &hi);
	      hi += lo;
	    }
	  else c += sscanf(argv[3], "%lx", &hi);
	  
	  if (c != 2 || hi < lo || g_watches==MAXWATCH)
	    {
	      printf("Watch range numbers malformed\n");
	      exit(1);
	    }
	  Watches[g_watches].lo = lo;
	  Watches[g_watches].hi = hi;
	  g_watches += 1;
	  argc -= 3; argv += 3; continue;
	}

      else if (!strcmp(argv[1], "-wait-debugger"))
	{ // Wait for the debugger to connect before starting program
	  wait_debugger = true;
	  argc -= 1; argv += 1;
	  continue;
	}
      else if (!strcmp(argv[1], "-putchar-backdoor-nohandles"))
	{ // Wait for the debugger to connect before starting program
	  putchar_backdoor_with_handles = false;
	  argc -= 1; argv += 1;
	  continue;
	}
      else if (!strcmp(argv[1], "-verilated"))
	{ // Default is fast ISS.
	  use_verilated = true;
	  argc -= 1; argv += 1;
	  continue;
	}
      else if (argc > 2 && !strcmp(argv[1], "-image"))
	{
	  image_lo =argv[2];
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (argc > 2 && !strcmp(argv[1], "-deviceini")) 
	{
	  device_ini = argv[2];
	  argc -= 2;
	  argv += 2;
	  continue;
	}
      else if(argc > 2 && !strcmp(argv[1], "-systemini"))
	  {
	    system_ini = argv[2];
	    argc -= 2;
	    argv += 2;
	    continue;
	  }
      else if (argc > 2 && !strcmp(argv[1], "-name"))
	{
	  g_name = argv[2];
	  new tenos_report_item("name", "", g_name);
#ifdef TLM_POWER3
	  sc_pwr::simulation_title(g_name);
#endif // TLM_POWER3
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (argc > 2 && !strcmp(argv[1], "-confidence"))
	{
	  g_confidence = atoi(argv[2]);
	  assert(g_confidence >= 2);
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (argc > 2 && !strcmp(argv[1], "-imagehi"))
	{
	  image_hi =argv[2];
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (argc > 2 && !strcmp(argv[1], "-uart-input"))
	{
	  // Note: Immediate string or file data for uart model input.
	  // Note: the uart model will handle input starting with a dot or a slash as a file to read from
	  uart_canned_input = argv[2];
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (argc > 2 && !strcmp(argv[1], "-vcd-trace-filename"))
	{
	  g_vcd_trace_filename = argv[2];
	  argc -= 2; argv += 2;
	  continue;
	}
      else if (!strcmp(argv[1], "--")) // All further args passed by backdoor to simulated environment.
	{
	  argv_backdoor_su = new argv_backdoor_setup(image_lo, argc-2, argv+2); // Copy these ready for backdoor access
	  break;
	}
      else
	{
	  fprintf(stderr, "Bad cmdline argument '%s'\nTo see supported command line args please read main.cpp\n", argv[1]);
	  SC_REPORT_FATAL("main.cpp", "bad argument");
	}
    }

  assert (n_cores <= MAX_NO_OF_CORES);
  
  if (g_vcd_trace_filename)
    {
      g_Tf = sc_create_vcd_trace_file(g_vcd_trace_filename);
      // ((vcd_trace_file*)g_Tf)->sc_set_vcd_time_unit(-9);//NS resolution - not in Systemc 3.2 ?
    }
#ifdef TLM_POWER3
  char line0[132], line1[132];
  snprintf(line0, 132, "/tmp/%s.vcd", g_name);
  snprintf(line1, 132, "/tmp/%s.plt", g_name);
  //g_vcd_pt = pw_create_vcd_trace_file(line0, line1, PlotStyleDecaying);
  snprintf(line0, 132, "%s.power.txt", g_name);
  g_txt_pt = pw_create_txt_trace_file(line0);
  //g_slk_pt = pw_create_slk_trace_file(g_name);
#endif // TLM_POWER3


#ifdef TLM_POWER3
    //! Set Power and Energy value for dealing with overflow
    pw_set_power_resolution(1, PW_fW);
    pw_set_energy_resolution(1, PW_fJ);
#endif // TLM_POWER3

    if(system_ini == 0 || device_ini == 0) {
      std::cout << "Need to specify device and system ini files for DRAMSIM2!" << std::endl;
      return 0;
    }
    the_benchconfig = new top ("the_top", n_cores, g_harvardf, device_ini, system_ini);
    the_benchconfig->reset(image_lo, image_hi);

#ifdef TLM_POWER3
    std::cout<< "child mode =" << also_trace_children << __LINE__ << "\n";
    //pw_trace(g_txt_pt, *the_benchconfig, "NEWTOPNAME", also_trace_children);
    //pw_trace(g_txt_pt, *the_benchconfig, "NEWTOPTOTAL", sum_children);



//    pw_trace(g_slk_pt, *the_benchconfig, "BENCHCONFIG");
//    pw_trace(g_slk_pt, (the_benchconfig->memory0), "Memory 0");
//    pw_trace(g_slk_pt, (the_benchconfig->memory1), "Memory 1");
//    pw_trace(g_slk_pt, (the_benchconfig->busmux0), "BusMux 0");
//    pw_trace(g_slk_pt, (the_benchconfig->busmux1), "BusMux 1");
//    pw_trace(g_slk_pt, (the_benchconfig->uart0),   "Uart 0");
#endif
    
    for(int i=0;i<n_cores;i++)
      {
	char txt[20];
	sprintf(txt, "mipsnode_%d", i);
#ifdef TLM_POWER3
	pw_trace(g_vcd_pt, *(the_benchconfig->Cores[i]), txt);
	pw_trace(g_txt_pt, *(the_benchconfig->Cores[i]), txt);
	pw_trace(g_slk_pt, *(the_benchconfig->Cores[i]), txt);
#endif
      }       

    if (global_qk_ns)
      {
	tlm_utils::tlm_quantumkeeper::set_global_quantum(sc_time(global_qk_ns, SC_NS));
      }
    else std::cout << "Using default quantum of " << tlm_utils::tlm_quantumkeeper::get_global_quantum() << "\n";
    printf("Simulation is beginning. Harvard=%i cores=%i\n", g_harvardf, n_cores);
  sc_start();

  if (1)
    {
      char line0[232];
      snprintf(line0, 232, "%s.stat_rpt.txt", g_name);
      FILE *d = fopen(line0, "w");
      if (d) 
	{
	  the_benchconfig->stat_report("eos spooled", d);
	  tenos_report_items("eos spooled", d);
	  fclose(d);
	}
    }

  tenos_report_items("eos stdout", stdout);
  the_benchconfig->stat_report("eos stdout", stdout);
  if (g_Tf) sc_close_vcd_trace_file(g_Tf);

#ifdef TLM_POWER3
  if (g_vcd_pt) pw_close_vcd_trace_file(g_vcd_pt);
  if (g_txt_pt) pw_close_txt_trace_file(g_txt_pt);
  if (g_slk_pt) pw_close_slk_trace_file(g_slk_pt);
#endif // TLM_POWER3


  cout << " \t- Simulation Time: " << sc_time_stamp() << endl;

  return 0;
}


// For LT should add on the run-ahead 'delay'
int backdoor_counter_ticks()
{
  int r = sc_time_stamp() / sc_time(1, SC_US);
  //printf("Backdoor_counter_ticks returns %i\n", r);
  return r;
}
// eof
