// $Id: uart64_cbg.h,v 1.3 2011/07/25 15:33:56 my294 Exp $
// (C) 2008-11 DJ Greaves.
// cbg TLM/ESL console uart model: in popup xterm or using stdin/out depending on the console mode
//
#ifndef UART64_CBG_H
#define UART64_CBG_H

#include <stdio.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

#include "tenos.h"
#include "systemc.h"
#include "tlm.h"
#include "tlm_utils/simple_target_socket.h"


// Programmer's model
#define UART2_SEND    0x10  // Register offsets - one d8 register every 8 bytes
#define UART2_RECEIVE 0x18
#define UART2_CONTROL 0x20
#define UART2_STATUS  0x28

#define UART2_STATUS_RX_EMPTY (0x80)
#define UART2_STATUS_TX_EMPTY (0x40)


#define UART2_CONTROL_RX_INT_ENABLE (0x20)
#define UART2_CONTROL_TX_INT_ENABLE (0x10)



#ifdef TLM_POWER3
#include <tlm_power>
#define POWER3(X) X
using namespace sc_pwr;
#else
typedef tlm::tlm_base_protocol_types PW_TLM_TYPES;
typedef tlm::tlm_generic_payload PW_TLM_PAYTYPE;
#define POWER3(X)
#endif


// O. Celebican, T. Simunic Rosing and V. Mooney, "Energy Estimation of Peripheral Devices in Embedded Systems," Proceedings of the 2004 ACM Great Lakes Symposium on VLSI (GLVLSI'04), pp.430-435, April 2004.



class uart64_cbg : public sc_module
#ifdef TLM_POWER3
, public pw_module
#endif
{
  SC_HAS_PROCESS(uart64_cbg);
  POWER3(PW_TLM3(sc_pwr::tlm_bit_transition_tracker read_bus_tracker)); // Used if counting wire transitions. 
  bool use_stdin;
  int xterm_opened, threads_started, idle_count;
  FILE *output_f, *input_f;
  int xterm_fd;
  bool xconsole;
  void open_xterm();
  volatile int logged, yielding;
  pthread_t input_thread0, input_thread1;
  sc_time latency;
  const char *canned_input;
  FILE *canned_fd;
  bool txready;

  struct stats_t
  {
    int reads, writes, ins, outs;
    stats_t() { reset(); }
    void reset()
    {
      reads = 0;
      writes =0;
      ins = 0;
      outs = 0;
    }
  } stats;

  
  // blocking transport
  void b_access(PW_TLM_PAYTYPE &trans, sc_time &delay);




  int testch();
  char rdch();
  char rdch_nonblock();
  void uart_wrch(char);
  void flush();

  // Programmer's model registers
  u8_t status_register_read(); // Not an actual register - created dynamically on each read.
  u8_t control_register;

  // Combinational interrupt output: manually call this whenever 
  // supporting fields (the support) are changed, instead of having 
  // a dedicated SystemC SC_THREAD.
  void update_interrupt();

  void end_of_simulation();
public:
  int open_log_file(const char *fn);  
  void *input_process(void *);// public for pthread callback (yuck).


public:
  traceregion *traceregions;

  // constructor
  uart64_cbg(sc_module_name name, bool x, bool u);

  const char *kind();
  void stat_report(const char *msg, FILE *fd, bool resetf=0);

  //TLM-2 socket, defaults to 32-bits wide, power protocol
  tlm_utils::simple_target_socket<uart64_cbg, 64, PW_TLM_TYPES> port0;


  // Note: Immediate string or file data for uart model input.
  // Note: the uart model will handle input starting with a dot or a slash as a file to read from
  void register_canned_input(const char *d);

  // Pass the address of this field to targets that want to be interrupted.
  bool interrupt_request;
};

#endif

// eof
