#ifndef LCDC64_H
#define LCDC64_H
// $Id: $
// (C) 2008-11 DJ Greaves.
// cbg TLM/ESL LCD display and controller.
//
// (c) 2005 Jerome Cornet,  2007 Matthieu Moy

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "systemc.h"
#include "tenos.h
#include "tlm.h"
#include "tlm_utils/simple_target_socket.h"

#ifndef POWER3
#ifdef TLM_POWER3
#include <tlm_power>
#define POWER3(X) X
using namespace sc_pwr;
#else
typedef tlm::tlm_base_protocol_types PW_TLM_TYPES;
typedef tlm::tlm_generic_payload PW_TLM_PAYTYPE;
#define POWER3(X)
#endif
#endif


class LCDC64 : sc_core::sc_module
{

  SC_HAS_PROCESS(LCDC64);
   
  void compute();
  void draw();
  void fill_buffer();
  
  void end_of_elaboration();
  void init_colormap();
  
  tlm::tlm_response_status read(const basic::addr_t &a,       basic::data_t &d);
  
  tlm::tlm_response_status write(const basic::addr_t &a, const basic::data_t &d);

  
  // blocking transport
  void b_access(PW_TLM_PAYTYPE &trans, sc_time &delay);
  
  Display           *display;
  Window             window;
  int                screen;
  int                depth;
  GC                 gc;
  char              *buffer;
  XImage            *image;
  Colormap           cmap;
  int                color_table[256];
  
  unsigned long      addr_register;
  unsigned long      int_register;
  
  bool               started;
  sc_core::sc_event  start_event;
  
  sc_core::sc_time   period;
  
  static const int   kWidth;
  static const int   kHeight;

 public:
  simple_target_socket<LCDC64, 64, PW_TLM_TYPES>    port0;
  sc_core::sc_out<bool>         display_int;

  LCDC64(sc_core::sc_module_name name,
	 const sc_core::sc_time & display_period);

  ~LCDC64();

};

#endif
