#ifndef ETHERCRC_TLM_H
#define ETHERCRC_TLM_H

/* $Id: ethercrc_tlm.h,v 1.2 2011/03/22 07:45:01 djg11 Exp $
 *
 * (C) 2009-10 DJ Greaves - Ethernet CRC coprocessor example
 */

#include "systemc.h"

#include "tlm.h"


#include "tlm_utils/simple_target_socket.h"
#include "tenos.h"

#include "ethercrc_bev_core.h"


#ifdef TLM_POWER3
#include <tlm_power>
#define POWER3(X) X
using namespace sc_pwr;
#else
typedef tlm::tlm_base_protocol_types PW_TLM_TYPES;
typedef tlm::tlm_generic_payload PW_TLM_PAYTYPE;
#define POWER3(X)
#endif


class ethercrc_tlm:
  public sc_module
#ifdef TLM_POWER3
  ,  public pw_module
#endif
{
  SC_HAS_PROCESS(ethercrc_tlm);
  POWER3(sc_pwr::tlm_bit_transition_tracker read_bus_tracker); // Used if counting wire transitions. 
  const sc_time latency;

  ethercrc_bev_core bevcore;

  // blocking transport
  void b_access(PW_TLM_PAYTYPE &trans, sc_time &delay);

public:
  traceregion *traceregions; // Debug tracing control.

  //TLM-2 socket, defaults to 64-bits wide, power protocol.
  tlm_utils::simple_target_socket<ethercrc_tlm, 64, PW_TLM_TYPES> port0;
  

  // Constructor
  ethercrc_tlm(sc_module_name name);
  const char *kind() { return "ethercrc_tlm"; }


};

#endif


