#ifndef ETHERCRC_MEMMAP_H
#define ETHERCRC_MEMMAP_H

// Memory map (programmer's model) for programmed I/O operations on this device.


// We can perform programmed I/O on this component by reading and writing to the following registers.

// Each register has an offset from a system-dependent base address.

#define CRC_RESET_REG              8   // Write any value here to reset this CRC unit.

#define CRC_DATA_8_PROCESS_REG     16  // Write one byte here to have it included in the CRC

#define CRC_DATA_32_PROCESS_BE_REG 24  // Writa big-endian word here to have it included  

#define CRC_DATA_32_PROCESS_LE_REG 32  // Write a little-endian word here to have it included  

#define CRC_READ_REG               48  // Read here for current crc value in host endian

#define CRC_CONTROL_REG            56  // Read/write here for control/status flags (if needed.)


#endif
