#ifndef ETHERCRC_BEV_CORE_H
#define ETHERCRC_BEV_CORE_H

// Ethernet CRC Processor - behavioural model
// $Id: ethercrc_bev_core.h,v 1.1 2011/03/22 07:30:34 djg11 Exp $


#include <stdint.h>

const uint32_t ethernet_polynomial_le = 0xedb88320U;

class ethercrc_bev_core
{
  uint32_t crc_reg;
  uint32_t control_reg;

public:
  uint32_t read_crc();
  uint32_t read_control();
  void write_control(uint32_t);
  void reset_operation();
  void process_byte(uint8_t dd);
  void process_word32_be(uint32_t dd);
  void process_word32_le(uint32_t dd);
};



#endif
