// (C) 2009-11 D J Greaves
// University of Cambridge, Computer Laboratory.
// ACS P35 SoC D/M Classes - $Id: busmux64.h,v 1.6 2011/08/22 13:30:19 djg11 Exp $
// Generic payload blocking transport router for modelling contention.

#ifndef BUSMUX64_H
#define BUSMUX64_H

#include "systemc.h"

#include "tlm.h"
#include "tlm_utils/multi_passthrough_initiator_socket.h"
#include "tlm_utils/multi_passthrough_target_socket.h"
#include "tenos.h"

#include <queue>

#ifndef POWER3
#ifdef TLM_POWER3
#include <tlm_power>
using namespace sc_pwr;
#define POWER3(X) X
#else
typedef tlm::tlm_base_protocol_types PW_TLM_TYPES;
typedef tlm::tlm_generic_payload PW_TLM_PAYTYPE;
#define POWER3(X)
#endif
#endif



#define MAX_TARGETS 64


class busmux64: 
  public sc_module
#ifdef TLM_POWER3
, public pw_module
#endif
{
  sc_mutex ml;
  sc_event/*_queue*/ wake_event[MAX_TARGETS];
  std::queue<int> requests[MAX_TARGETS];
  struct stats_t
  {
    int operations;
    int contended_operations;
    sc_time service_time;
    sc_time response_time;
    stats_t() { reset(); }
    void reset()
    {
      operations = 0;
      contended_operations = 0;
      response_time = SC_ZERO_TIME;
      service_time = SC_ZERO_TIME;
    }
    void stat_report(busmux64 *p, const char *msg, FILE *fd, bool resetf=false);
    void log(sc_time start_q, sc_time start_op, sc_time end_op)
    {
      response_time += (end_op - start_q);
      service_time += (end_op - start_op);
    }
  } stats;


  int route(int id, PW_TLM_PAYTYPE &trans);
  
 public:
  traceregion *traceregions;

#ifdef CYCLE_ACCURATE
  volatile bool busy_flags[MAX_TARGETS];
#endif

  // Use tagged sockets to be able to distinguish incoming backward path calls
  tlm_utils::multi_passthrough_target_socket<busmux64, 64, PW_TLM_TYPES>    targ_socket;
  tlm_utils::multi_passthrough_initiator_socket<busmux64, 64, PW_TLM_TYPES> init_socket;

  // forwarding type
  enum fwd_type {
    THRESHOLD, // use threshold variable
    ONE_TO_ONE, // use one to one mapping 
    MANY_TO_ONE // uses many to one mapping
  } fwd;

  // Constructor
  busmux64(sc_core::sc_module_name name, 
	   u64_t thres0, 
	   u64_t thres1=0,
	   fwd_type fwd = THRESHOLD);

  // FORWARD PATH
  // TLM-2 blocking transport method
  bool get_direct_mem_ptr(int n, PW_TLM_PAYTYPE&, tlm::tlm_dmi& dmi_data);
  void b_transport(int id, PW_TLM_PAYTYPE &trans, sc_time &delay);
  u64_t thres0, thres1;
  void stat_report(const char *msg, FILE *fd, bool resetf=false);

  bool cycle_accurate() { 
#ifdef CYCLE_ACCURATE
    return true;
#else
    return false;
#endif
  }
 private:
#ifdef TLM_POWER3
  pw_energy std_energy_op;
#endif


};

#endif
// eof
