/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/


#include <iostream>

#include <systemc>
#include <tlm_power>

using namespace std;
using namespace sc_core;
using namespace sc_pwr;


// ===========================================================================
pw_trace_file* g_file_pt = NULL;


// ---------------------------------------------------------------------------
class AAA:
    public sc_module,
    public pw_module_base
{
    public:
        SC_HAS_PROCESS(AAA);
        AAA(const sc_core::sc_module_name& p_name):
            sc_module(p_name),
            pw_module_base()
        {
            SC_THREAD(process);
        }

        void process(void)
        {
            wait(1, SC_MS);
            set_dynamic_power(pw_power(1, PW_pW));
            wait(1, SC_MS);
            set_static_power(pw_power(1, PW_pW));
            wait(1, SC_MS);
            set_dynamic_power(PW_ZERO_POWER);
            set_static_power(PW_ZERO_POWER);
        }
};


// ---------------------------------------------------------------------------
class AAB:
    public sc_module,
    public pw_module_base
{
    public:
        SC_HAS_PROCESS(AAB);
        AAB(const sc_core::sc_module_name& p_name):
            sc_module(p_name),
            pw_module_base()
        {
            SC_THREAD(process);
        }

        void process(void)
        {
            wait(10, SC_MS);
            set_dynamic_power(pw_power(10, PW_pW));
            wait(10, SC_MS);
            set_static_power(pw_power(10, PW_pW));
            wait(10, SC_MS);
            set_dynamic_power(PW_ZERO_POWER);
            set_static_power(PW_ZERO_POWER);
        }
};


// ---------------------------------------------------------------------------
class ABA:
    public sc_module
{
    public:
        ABA(const sc_core::sc_module_name& p_name):
            sc_module(p_name)
        { }
};


// ---------------------------------------------------------------------------
class ABB:
    public sc_module
{
    public:
        ABB(const sc_core::sc_module_name& p_name):
            sc_module(p_name)
        { }
};


// ---------------------------------------------------------------------------
class ABC:
    public sc_module,
    public pw_module_base
{
    public:
        SC_HAS_PROCESS(ABC);
        ABC(const sc_core::sc_module_name& p_name):
            sc_module(p_name),
            pw_module_base()
        {
            SC_THREAD(process);
        }

        void process(void)
        {
            wait(100, SC_MS);
            set_dynamic_power(pw_power(100, PW_mW));
            wait(100, SC_MS);
            set_static_power(pw_power(100, PW_mW));
            wait(100, SC_MS);
            set_dynamic_power(PW_ZERO_POWER);
            set_static_power(PW_ZERO_POWER);
            pw_close_txt_trace_file(g_file_pt);
        }
};


// ---------------------------------------------------------------------------
class AC:
    public sc_module,
    public pw_module_base
{
    public:
        SC_HAS_PROCESS(AC);
        AC(const sc_core::sc_module_name& p_name):
            sc_module(p_name),
            pw_module_base()
        {
            SC_THREAD(process);
        }

        void process(void)
        {
            wait(1000, SC_MS);
            set_dynamic_power(pw_power(1000, PW_mW));
            wait(1000, SC_MS);
            set_static_power(pw_power(1000, PW_mW));
            wait(1000, SC_MS);
            set_dynamic_power(PW_ZERO_POWER);
            set_static_power(PW_ZERO_POWER);
        }
};


// ---------------------------------------------------------------------------
class AB:
    public sc_module,
    public pw_module_base
{
    public:
        ABA a_aba;
        ABB a_abb;
        ABC a_abc;

        SC_HAS_PROCESS(AB);
        AB(const sc_core::sc_module_name& p_name):
            sc_module(p_name),
            pw_module_base(),
            a_aba("ABA"),
            a_abb("ABB"),
            a_abc("ABC")
        {
            SC_THREAD(process);
        }

        void process(void)
        {
            wait(10000, SC_MS);
            set_dynamic_power(pw_power(10000, PW_pW));
            wait(10000, SC_MS);
            set_static_power(pw_power(10000, PW_pW));
            wait(10000, SC_MS);
            set_dynamic_power(PW_ZERO_POWER);
            set_static_power(PW_ZERO_POWER);
        }
};

// ---------------------------------------------------------------------------
class AA:
    public sc_module
{
    public:
        AAA a_aaa;
        AAB a_aab;

        AA(const sc_core::sc_module_name& p_name):
            sc_module(p_name),
            a_aaa("AAA"),
            a_aab("AAB")
        { }
};


// ---------------------------------------------------------------------------
class A:
    public sc_module
{
    public:
        AA a_aa;
        AB a_ab;
        AC a_ac;

        A(const sc_core::sc_module_name& p_name):
            sc_module(p_name),
            a_aa("AA"),
            a_ab("AB"),
            a_ac("AC")
        { }
};


// ---------------------------------------------------------------------------
int sc_main(int argc, char* p_argv[])
{
    // Handler management
    sc_set_time_resolution(1, SC_FS);
    pw_set_power_resolution(1, PW_fW);
    pw_set_energy_resolution(1, PW_fJ);

    A l_a("A");

    g_file_pt =
        pw_create_txt_trace_file("trace");
    pw_trace(g_file_pt,
             l_a,
             "A");
    pw_trace(g_file_pt,
             l_a.a_ab,
             "AB");
    pw_trace(g_file_pt,
             l_a.a_ac,
             "AC");


    sc_pwr::pw_stat_observer_base *it = pw_get_observer(&l_a, sc_pwr::sum_children);
    
    sc_start();
    sc_stop();

    std::cout << "Energy in account " << it->get_global_name(0) 
	      << " is  " <<  it->get_energy(0) << "\n";
    std::cout << "Energy in all accounts " << it->get_energy() << "\n";

    return 0;
}
