// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_phase.cpp,v 1.1 2011/06/30 11:10:38 my294 Exp $

/** @file pw_phase.cpp
 * @brief Define different kinds of power phase which can be used by a System 
 * Component.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 */



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
// POWER PHASE CODE

const char* PW_PHASE_INIT =         "INIT";
const char* PW_PHASE_IDLE =         "IDLE";
const char* PW_PHASE_WAIT =         "WAIT";
const char* PW_PHASE_PROCEED =      "PROCEED";
const char* PW_PHASE_READ =         "READ";
const char* PW_PHASE_WRITE =        "WRITE";
const char* PW_PHASE_SEND =         "SEND";
const char* PW_PHASE_RECEIVE =      "RECEIVE";
const char* PW_PHASE_SEND_RECEIVE = "SEND_RECEIVE";
const char* PW_PHASE_COMMUNICATE =  "COMMUNICATE";
const char* PW_PHASE_CONFIG =       "CONFIG";
const char* PW_PHASE_COMPUTE =      "COMPUTE";
const char* PW_PHASE_ROUTE =        "ROUTE";
const char* PW_PHASE_INTERRUPT =    "INTERRUPT";
const char* PW_PHASE_CHECK =        "CHECK";
const char* PW_PHASE_UNDEF =        "UNDEF";


} // namespace sc_pwr
