// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_observer_if.cpp,v 1.1 2011/06/30 11:10:38 my294 Exp $

/** @file pw_observer_if.cpp
 * @brief Implementation of the observer interface class of the observer 
 * design pattern.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * This class allow an observer to be notified (call of its update method) 
 * when the state of one of its monitored subjects is changing.  It implements 
 * the design pattern Observer from the gang of 4.  More information about 
 * this design pattern can be found in the book: Desgin Patterns -- Erich 
 * Gamma, Richard Helm, Ralph Johnson, John Vlissides.
 */

#include "pw_observer_if.h"
#include "pw_debug.h"



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
pw_observer_if::~pw_observer_if(void)
{
    // XXX Nothing special todo, but we want a virtual destructor: Risk of 
    // memory leak with the derived classes.
}

} // namespace sc_pwr
