// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_common.cpp,v 1.1 2011/06/30 11:10:37 my294 Exp $

/** @file pw_common.cpp
 * @brief Common function used by the pwr library.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * Contain different functions and constant commonly used.
 */

#include <systemc>



// ===========================================================================
namespace
{


// ---------------------------------------------------------------------------
/**
 * @brief Local function computing the maximal time value.
 * @param[in] p_time initially the time resolution
 * @param[in] p_rec recursive counter.
 */
const sc_core::sc_time time_max_rec(sc_core::sc_time p_time,
                                    unsigned int p_rec)
{
    if(p_rec == 64)
        return p_time;
    else
    {
        const sc_core::sc_time l_time(time_max_rec(p_time, p_rec+1));
        return p_time + l_time + l_time;
    }
}


} // ANONYMOUS NAMESPACE (replace static declaration)



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
/**
 * @brief Define the maximal time value.
 * @note We use a macros instead of a constant for not fixing the time 
 * resolution.
 */
const sc_core::sc_time& sc_time_max(void)
{
    static const sc_core::sc_time g_time_max =
        time_max_rec(sc_core::sc_get_time_resolution(), 1);

    return g_time_max;
}


} // namespace sc_pwr
