// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_utils_ids.h,v 1.2 2011/07/25 15:32:39 my294 Exp $

/** @file pw_utils_ids.h
 * @brief Define error messages for the pwr library
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * Reports ids in the range 200-299
 *
 */

#ifndef _PW_UTILS_IDS_
#define _PW_UTILS_IDS_



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
// POWER MAP CONFIGURATION ERROR CODES

//! /cea/pwr/tracing/200
extern const char* PW_MAP_CFG_FILE_NAME_TYPE_;
//! Failed to open configuration file 
extern const char* PW_MAP_CFG_FILE_NAME_MSG_;

//! /cea/pwr/tracing/201
extern const char* PW_MAP_UNDEF_KEY_TYPE_;
//! No power value associated to the couple 
extern const char* PW_MAP_UNDEF_KEY_MSG_;

//! /cea/pwr/tracing/202
extern const char* PW_MAP_MULTIPLE_DEF_TYPE_;
//! Redefinition of the power couple 
extern const char* PW_MAP_MULTIPLE_DEF_MSG_;

//! /cea/pwr/tracing/203
extern const char* PW_MAP_MALFORMED_POWER_VALUE_TYPE_;
//! Syntax error on power value definition 
extern const char* PW_MAP_MALFORMED_POWER_VALUE_MSG_;


//! /cea/pwr/tracing/204
extern const char* PW_MAP_OSTREAM_ERROR_TYPE_;
//! Failed to initialize output stream.
extern const char* PW_MAP_OSTREAM_ERROR_MSG_;

//! /cea/pwr/tracing/205
extern const char* PW_MAP_MALFORMED_ENERGY_VALUE_TYPE_;
//! Syntax error on power value definition 
extern const char* PW_MAP_MALFORMED_ENERGY_VALUE_MSG_;

//! /cea/pwr/tracing/206
extern const char* PW_MAP_MALFORMED_VOLTAGE_VALUE_TYPE_;
//! Syntax error on power value definition 
extern const char* PW_MAP_MALFORMED_VOLTAGE_VALUE_MSG_;

//! /cea/pwr/tracing/207
extern const char* PW_MAP_MALFORMED_LENGTH_VALUE_TYPE_;
//! Syntax error on length value definition 
extern const char* PW_MAP_MALFORMED_LENGTH_VALUE_MSG_;

} // namespace sc_pwr

#endif // _PW_UTILS_IDS_
