// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_module.h,v 1.2 2011/07/25 15:32:39 my294 Exp $

/** @file pw_module.h
 * @brief Base class used by the SystemC module for recording their power 
 * consumption.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * This class has to be used as a base class of the SystemC components for 
 * recording their power consumption.
 */

#ifndef _PW_MODULE_
#define _PW_MODULE_

#include <string>
#include <iostream>

#include <systemc>

#include "pw_module_base.h"
#include "pw_power.h"
#include "pw_phase.h"
#include "pw_power_map.h"
#include "pw_physical_operators.h"


// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
/**
 * @brief Base class for the SystemC object which can be monitored.
 */
class pw_module:
    public pw_module_base
{
    public: // CONSTRUCTOR
        /**
         * @brief Per-instance constructor.
         * param[in] p_file_name input file name containing power/layout information.
         */
        pw_module(const char* p_file_name);
        /**
         * @brief Default constructor.
         * No parameters: the SystemC module 'kind' is used as a basis for the input file.
         */
        pw_module();  
        //! Virtual destructor
        virtual ~pw_module(void);

    public: // POWER RECORDING FUNCTION
        /**
         * Update the dynamic power according to the parameter mode and phase.
         * @param[in] p_mode the power mode.
         * @param[in] p_phase the power phase.
         */
        void update_power(const std::string& p_mode,
                          const std::string& p_phase = PW_PHASE_UNDEF);

    public: // ACCESS FUNCTION

        //! XXX Makes Visible the overloaded method inherited.
        using pw_module_base::get_phasemode_power;

	
    public: // MISCELLANOUS FUNCTIONS
        //! Return an informative string about this power module.
        virtual const std::string to_string(void) const;

    private: // PRIVATE ATTRIBUTES
        //! Power map containing the power information
        pw_power_map a_map;

    private: // DISABLED FUNCTIONS

        //! Disabled default copy constructor.
        pw_module(const pw_module&);

        //! Disabled assignment operator.
        pw_module& operator=(const pw_module&);
}; // class pw_module

} // namespace sc_pwr


#endif // _PW_MODULE_
