// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_mode.h,v 1.1 2011/06/30 08:53:15 my294 Exp $

/** @file pw_mode.h
 * @brief Define differents kind of power mode which can be used by a System 
 * Component.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 */

#ifndef _PW_MODE_
#define _PW_MODE_



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
// POWER MODE CODE

//! Power mode ON
extern const char* PW_MODE_ON;     // "ON"
//! Power mode OFF
extern const char* PW_MODE_OFF;    // "OFF"
//! Power mode UNDEF
extern const char* PW_MODE_UNDEF;  // "UNDEF"


} // namespace sc_pwr

#endif // _PW_MODE_
