/*****************************************************************************
 *            Copyright (c) 2012, DJ Greaves, University of Cambridge
 * 
 * TLM POWER3 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/


#include <iostream>

#include <systemc>
#include <tlm_power>

using namespace std;
using namespace sc_core;
using namespace sc_pwr;


// ===========================================================================
pw_trace_file* g_file_pt = NULL;


// ---------------------------------------------------------------------------
class AA:
    public sc_module,
    public pw_module_base
{
    public:
        SC_HAS_PROCESS(AA);
        AA(const sc_core::sc_module_name& p_name):
            sc_module(p_name),
            pw_module_base()
        {
            set_static_power(pw_power(1, PW_mW));
            set_dynamic_power(pw_power(1, PW_mW));
	    SC_THREAD(process)
        }

        void process(void)
        {
            wait(1, SC_MS);
            set_dynamic_power(PW_ZERO_POWER);
            set_static_power(PW_ZERO_POWER);
	    std::cout << "End of process " << name() << " at " << sc_time_stamp() << "\n";
        }
};


// ---------------------------------------------------------------------------
class A:
    public sc_module
{
    public:
        AA a_aa0;
        AA a_aa1;

        A(const sc_core::sc_module_name& p_name):
            sc_module(p_name),
            a_aa0("aa0"),
            a_aa1("aa1")
        { }
};


// ---------------------------------------------------------------------------
int sc_main(int argc, char* p_argv[])
{
    // Handler management
    sc_set_time_resolution(1, SC_FS);
    pw_set_power_resolution(1, PW_fW);
    pw_set_energy_resolution(1, PW_fJ);

    A l_the_A("the_A");


    g_file_pt = pw_create_txt_trace_file("trace");
    pw_trace(g_file_pt, l_the_A);
    pw_trace(g_file_pt, l_the_A.a_aa1);


    sc_start();
    sc_stop();

    pw_close_txt_trace_file(g_file_pt);
    return 0;
}
