// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_tracing_ids.cpp,v 1.1 2011/06/30 11:10:38 my294 Exp $

/** @file pw_tracing_ids.cpp
 * @brief Define error messages for the pwr library
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * Reports ids in the range 100-199
 *
 */



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
// VCD TRACE FILE ERROR CODES

const char* PW_VCD_OBSERVER_UNAVAILABLE_TYPE_ =
    "/cea/pwr/tracing/101";
const char* PW_VCD_OBSERVER_UNAVAILABLE_MSG_ =
    "VCD observer unavailable.";


// ---------------------------------------------------------------------------
// MISCELLEANOUS ERROR CODES

const char* PW_TRACING_OSTREAM_ERROR_TYPE_ =
    "/cea/pwr/tracing/102";
const char* PW_TRACING_OSTREAM_ERROR_MSG_ =
    "Failed to initialize output stream.";


// ---------------------------------------------------------------------------
// STATISTIC OBSERVER ERROR CODES

const char* PW_POWERED_OBSERVER_KILLED_WITHOUT_STOP_TYPE_ =
    "/cea/pwr/tracing/105";
const char* PW_POWERED_OBSERVER_KILLED_WITHOUT_STOP_MSG_ =
    "Reach end of infinite simulation without calling sc_stop.";

const char* PW_POWERED_OBSERVER_STOPPED_ACTIVE_TYPE_ =
    "/cea/pwr/tracing/106";
const char* PW_POWERED_OBSERVER_STOPPED_ACTIVE_MSG_ =
    "Reached end of infinite simulation with non-null power value";

const char* PW_POWERED_OBSERVER_END_ACTIVE_TYPE_ =
    "/cea/pwr/tracing/107";
const char* PW_POWERED_OBSERVER_END_ACTIVE_MSG_ =
    "Reached end of infinite simulation without calling sc_stop.";


// ---------------------------------------------------------------------------
// TEXTUAL TRACE FILE ERROR CODES

const char* PW_TXT_TRACE_FILE_NAME_TYPE_ =
    "/cea/pwr/tracing/104";
const char* PW_TXT_TRACE_FILE_NAME_MSG_ =
    "Cannot open textual trace file";

const char* PW_TXT_TIME_ERROR_TYPE_ =
    "/cea/pwr/tracing/108";
const char* PW_TXT_TIME_ERROR_MSG_ =
    "Cannot calculate the current time: ";

const char* PW_TXT_REDONDANT_TRACE_TYPE_ =
    "/cea/pwr/tracing/109";
const char* PW_TXT_REDONDANT_TRACE_MSG_ =
    "Skip redundant textual trace of module ";


// ---------------------------------------------------------------------------
// OBSERVER ERROR CODES

const char* PW_OBSERVER_REDEFINITION_TYPE_ =
    "/cea/pwr/tracing/110";
const char* PW_OBSERVER_REDEFINITION_MSG_ =
    "Incoherent status of observer: already attached.";
  
  const char* PW_STAT_OBSERVER_TOO_MANY_ACCOUNTS_TYPE_ =
    "/cea/pwr/tracing/115";
  const char* PW_STAT_OBSERVER_TOO_MANY_ACCOUNTS_MSG_ =
    "Try to register too many accounts for observer.";


// ---------------------------------------------------------------------------
// SYLK (SYmbolic Link) TRACE FILE ERROR CODES

const char* PW_SLK_TRACE_FILE_NAME_TYPE_ =
    "/cea/pwr/tracing/111";
const char* PW_SLK_TRACE_FILE_NAME_MSG_ =
    "Cannot open textual trace file";

const char* PW_SLK_REDONDANT_TRACE_TYPE_ =
    "/cea/pwr/tracing/112";
const char* PW_SLK_REDONDANT_TRACE_MSG_ =
    "Skip redundant SYmbolic LinK (SYLK) trace of module ";

const char* PW_SLK_UNDEFINED_FUNCTION_TYPE_ =
    "/cea/pwr/tracing/113";
const char* PW_SLK_UNDEFINED_FUNCTION_MSG_ =
    "Functionality not yet implemented";

const char* PW_SLK_TRACE_LOCKED_TYPE_ =
    "/cea/pwr/tracing/114";
const char* PW_SLK_TRACE_LOCKED_MSG_ =
    "A module can not be traced after destroying sc_object: ";


} // namespace sc_pwr
