// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_trace.cpp,v 1.1 2011/06/30 11:10:38 my294 Exp $

/** @file pw_trace.cpp
 * @brief Tracing facilities for generating power consumption reports.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 */

#include <vector>

#include "pw_trace.h"
#include "pw_debug.h"
#include "pw_observer_ids.h"



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
using sc_core::sc_object;


// ---------------------------------------------------------------------------
  pw_trace_file::pw_trace_file()
  { 
  }


  // ---------------------------------------------------------------------------
  pw_trace_file::~pw_trace_file(void)
  {
    pw_debug << "Destructor invoked\n";
    // XXX Nothing special todo, but we want a virtual destructor for 
    // preventing memory leak with polymorphism.
  }
  
  
  // ---------------------------------------------------------------------------
  // 
  void pw_trace_all(pw_trace_file* p_file_pt, plot_control_t p_plot_control)
  {
    std::list<pw_subject *>::iterator l_it;
    if (!p_file_pt) return;
    for (l_it = pw_subject::g_all_pw_subjects.begin(); l_it != pw_subject::g_all_pw_subjects.end(); ++l_it) 
      {
	// Don't like this : here we get the sc_object and go back to the subject again: relying on the mapping we were wanting to avoid.
	assert(0);
	// TODO finish me...
	// sc_object *l_p = (*l_it)->get_sc_object();
	//pw_trace(p_file_pt, l_p, no_children, p_plot_control);
      }
  }


  // When we call pw_trace it calls the trace method of the trace_file
  void pw_trace(pw_trace_file* p_file_pt,
		sc_object& p_obj,
		const std::string& p_str,
		trace_t p_do_children,
		plot_control_t p_plot_control)
  {
    if (!p_file_pt) return;
    p_file_pt->trace(p_obj, p_str, p_do_children, p_plot_control);
  }
  
  
  //If we do not supply a name, one is read from the object.
  void pw_trace(pw_trace_file* p_file_pt,
		sc_core::sc_object& p_obj,
		trace_t p_do_children,
		plot_control_t p_plot_control)
  {
    pw_trace(p_file_pt, p_obj, p_obj.name(), p_do_children, p_plot_control);
  }
  
// ---------------------------------------------------------------------------

  // Recursively add observation of all children (that are not already included). 
  // We do not do the very top ones because these are already done by the global power.

  // Two modes:
  //   also_trace_children: Create an observer for each lower module in the SystemC design  (separate accounting).
  //   sum_children: Add each child to this observer so its consumption is summed in the local total.

  void pw_trace_file::trace_all_below(sc_object *pos, trace_t p_do_children, int p_d)
  {
    typedef std::vector< sc_core::sc_object* > vect_const;
    typedef std::vector< sc_core::sc_object* >::const_iterator vect_const_iterator;

    pw_debug << pos << "\n";
    pw_assert(p_do_children != no_children);
    if (!pos)
      { // Seed top of tree walk.
	const vect_const & l_objs = sc_core::sc_get_top_level_objects();
	for(vect_const_iterator l_it = l_objs.begin();
	    l_it != l_objs.end();
	    ++l_it)
	  trace_all_below(*l_it, p_do_children, 1);
      }
    else if (p_do_children == also_trace_children)
      { // Recursive step for also_trace_children.
	// The recursive step for sum_children is in the observer_base.

	// pw_stat_observer_base *l_observer_pt = pw_get_observer(&p_obj, p_do_children);
	sc_module *mod = dynamic_cast<sc_module *>(pos);
	if (mod)
	  {
	    //pw_module_base *pmod = dynamic_cast<pw_module_base *>(mod);
	    //printf("Siz %s %s %p\n", mod->name(), mod->kind(), pmod);

	    //const char *l_aid = (p_do_children == sum_children) ? PW_STAT_OBSERVER_ATTRIBUTE_ID_CHILD_SUMMED: PW_STAT_OBSERVER_ATTRIBUTE_ID_SINGLE_MODULE;
	    //sc_core::sc_attr_base *l_attr_pt = mod->get_attribute(l_aid);
	    pw_debug << "also_trace_children: consider " << mod->name() << " d=" << p_d << "\n";
	    if (p_d == 1) // Do not call when d==0 since that is not 'below'.
	      {
		trace(*dynamic_cast<sc_object *>(mod), mod->name(), p_do_children);
	      }
	  }
	const vect_const l_objs = pos->get_child_objects();
	for(vect_const_iterator l_it = l_objs.begin();
	    l_it != l_objs.end();
	    ++l_it)
	  trace_all_below(*l_it, p_do_children, p_d+1);
      }
  }
// ---------------------------------------------------------------------------

void pw_set_time_unit(pw_trace_file* p_file_pt,
                      double p_value,
                      sc_core::sc_time_unit p_unit)
{
  if (!p_file_pt) return;
  p_file_pt->set_time_unit(p_value,
			   p_unit);
}


  // ---------------------------------------------------------------------------
  void pw_write_comment(pw_trace_file* p_file_pt,
                      const std::string& p_str)
  {
    if (!p_file_pt) return;
    p_file_pt->write_comment(p_str);
  }


  // ---------------------------------------------------------------------------
    static std::string g_simulation_title = "notitle";

    std::string simulation_title(const char *p_set)
    {
      if (p_set) g_simulation_title = p_set;
      return g_simulation_title;
    }

} // namespace sc_pwr

