// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_subject.cpp,v 1.1 2011/06/30 11:10:38 my294 Exp $

/** @file pw_subject.cpp
 * @brief Implementation of the subject base class of the observer design 
 * pattern.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * This class allow the observer attached to be notify when its state is 
 * changing.  It implements the design pattern Observer from the gang of 4.  
 * More information about this design pattern can be found in the book: Desgin 
 * Patterns -- Erich Gamma, Richard Helm, Ralph Johnson, John Vlissides.
 */

#include "pw_subject.h"
#include "pw_debug.h"



// ===========================================================================
namespace sc_pwr
{

  //! All of the pw_subject records in the system.
  std::list< pw_subject * > pw_subject::g_all_pw_subjects;

  // ---------------------------------------------------------------------------
  pw_subject::pw_subject(void): // constructor
    a_tab_observers()
  { 
    g_all_pw_subjects.push_back(this);
  }
  

// ---------------------------------------------------------------------------
  pw_subject::~pw_subject(void) // destructor
  {
    // XXX Nothing special todo, but we want a virtual destructor to avoid any
    // memory leak with the derived classes.
  }


  // ---------------------------------------------------------------------------
  // Attach is called by pw_observer_base when it is constructed or when it is part of a submodule tree.
  void pw_subject::attach(pw_observer_if& p_observer, const char *p_aid)
  {
    //printf("attached an observer %p '%s'\n", &p_observer, p_aid);
    a_tab_observers.push_back(&p_observer);
  }
  

  // ---------------------------------------------------------------------------
  void pw_subject::detach(pw_observer_if& p_observer)
  {
    a_tab_observers.remove(&p_observer);
  }


  // ---------------------------------------------------------------------------
  void pw_subject::notify(void)
  {
    typedef std::list< pw_observer_if* >::iterator iterator;
    iterator l_it = a_tab_observers.begin();

    // assert(l_it != a_tab_observers.end()); // Should be observed by the global observer at least!

    for(;
        l_it != a_tab_observers.end();
        ++l_it)
      {
	//std::cout << "tmp debug : Doing an update of an observer" << ((void *)(*l_it)) << "\n" ; //<< *l_it << "\n ";
        (*l_it)->update(*this);
      }
  }


} // namespace sc_pwr
