// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/********************************************************************
 * Copyright (C) 2010 by Verimag                                    *
 * Initial author: Matthieu Moy                                     *
 * This file must not be distributed outside Verimag                *
 ********************************************************************/

/*!
  \file pw_param.cpp
  \brief body for the file pw_param.h

  
*/

#include "pw_param.h"

const char* sc_pwr::PW_BAD_PARAM_TYPE_TYPE_ =
	"/verimag/pwr/kernel/0";
const char* sc_pwr::PW_BAD_PARAM_TYPE_MSG_ =
	"Incorrect type for param.";

const char* sc_pwr::PW_BAD_PARAM_TYPE_ =
	"/verimag/pwr/kernel/1";
const char* sc_pwr::PW_BAD_PARAM_MSG_ =
	"Incorrect param name.";

std::ostream& sc_pwr::operator<<(std::ostream& p_os,
				 const sc_pwr::power_params& m) {
	bool first = true;
	for(power_params::map_type::const_iterator i = m.m_map.begin();
	    i != m.m_map.end();
	    i++) {
		if (first) first = false;
		else p_os << ", ";

		p_os << i->first << " = " << i->second->to_string();
	}
	return p_os;
}
