// TLM_POWER3: Length-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_module.cpp,v 1.2 2011/07/25 15:32:45 my294 Exp $

/** @file pw_module.cpp
 * @brief Base class used by the SystemC module for recording their power 
 * consumption.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * This class has to be used as a base class of the SystemC components for 
 * recording thier power consumption.
 */

#include "pw_module.h"
#include "pw_kernel_ids.h"
#include "pw_debug.h"
#include "iostream"
#include "csignal"

using namespace std;
using namespace sc_core;
// ===========================================================================
namespace sc_pwr
{

// ---------------------------------------------------------------------------

// Create a filename using the SC_OBJECT kind as a basis.
pw_module::pw_module():
    pw_module_base(),
    a_map("TODO")
{

  //const char *k =   get_sc_object().kind();

  
}


pw_module::pw_module(const char* p_file_name):
    pw_module_base(),
    a_map(p_file_name)
{ 
  //cout << "uctor running\n";
  set_scaled_static_power(a_map.get_scaled_static_power());
  set_vcc(a_map.get_nominal_vcc());
  //  cout << "<< vcc = " << a_map.get_nominal_vcc()
  // << ", scaled = " << a_map.get_scaled_static_power()   << ">>";
  //  cout << p_file_name << " uctor done\n";
}

  // ---------------------------------------------------------------------------
  void pw_module::update_power(const std::string& p_mode,
			       const std::string& p_phase)
  {
    if(not a_map.is_defined(p_mode,
                            p_phase))
      {
        std::ostringstream l_msg;
        l_msg << PW_UNDEF_MODE_PHASE_MSG_
              << "(" << get_power_mode() << ", " << get_power_phase()
              << ") to (" << p_mode << ", " << p_phase << ").";
        SC_REPORT_WARNING(PW_UNDEF_MODE_PHASE_TYPE_,
                          l_msg.str().c_str());
        return;
      }
    
    pw_assert(false and "needs re-implementing");
    //set_dynamic_power(a_map.get_dynamic_power(p_mode, p_phase));
    //set_static_power(a_map.get_static_power(p_mode, p_phase));


    set_power_mode(p_mode);
    set_power_phase(p_phase);
  }
  
  // ---------------------------------------------------------------------------
  pw_module::~pw_module(void)
  {
    // Nothing special todo
  }
  
  // ---------------------------------------------------------------------------
  const std::string pw_module::to_string(void) const
  {
    return pw_module_base::to_string();
  }
  

} // namespace sc_pwr
