// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_subject.h,v 1.1 2011/06/30 08:53:15 my294 Exp $

/** @file pw_subject.h
 * @brief Implementation of the subject base class of the observer design 
 * pattern.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * This class allow the observer attached to be notify when its state is 
 * changing.  It implements the design pattern Observer from the gang of 4.  
 * More information about this design pattern can be found in the book: Desgin 
 * Patterns -- Erich Gamma, Richard Helm, Ralph Johnson, John Vlissides.
 */

#ifndef _PW_SUBJECT_
#define _PW_SUBJECT_

#include <list>

#include "pw_observer_if.h"



// ===========================================================================
namespace sc_pwr
{


  // ---------------------------------------------------------------------------
  /**
   * @brief Base class of object to monitor.
   */
  class pw_subject
  {
  public: // CONSTRUCTOR AND DESTRUCTOR
    //! Default Construtor
        pw_subject(void);
	
        //! Virtual Destructor for Polymorphism.
        virtual ~pw_subject(void);
	
	
  public: // OBSERVERS MANAGEMENT FUNCTIONS
        /**
         * @brief Attach an observer to this subject.
         * @param[in] p_observer Observer to attach.
         */
        virtual void attach(pw_observer_if& p_observer, const char *p_aid);

        /**
         * @brief Detach an observer from this subject.
         * @param[in] p_observer Observer to detach.
         */
        virtual void detach(pw_observer_if& p_observer);
	

  protected: // OBSERVERS MANAGEMENT FUNCTION
        //! Call the update method of each observer attached to this subject.
        void notify(void);
	

  public:
	//friend class pw_observer_base::global_power;
	//! All of the pw_subject records in the system.
	static std::list< pw_subject * > g_all_pw_subjects;

	
  private: // PRIVATE ATTRIBUTES
        //! List of the observers which monitor this subject.
        std::list< pw_observer_if* > a_tab_observers;


  }; // class pw_subject
  


} // namespace sc_pwr


#endif // _PW_SUBJECT_
