// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_physical_operators.h,v 1.1 2011/06/30 08:53:15 my294 Exp $

/** @file pw_physical_operators.h
 * @brief Define Physical operators between power, energy and time.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 */

#ifndef _PW_PHYSICAL_OPERATORS_
#define _PW_PHYSICAL_OPERATORS_

#include <systemc>

#include "pw_power.h"
#include "pw_energy.h"
#include "pw_length.h"
#include "pw_area.h"



// ===========================================================================
namespace sc_pwr
{

// ---------------------------------------------------------------------------
//! MULTIPLICATION between time and power.
pw_energy operator*(const pw_power&,
                    const sc_core::sc_time&);

// ---------------------------------------------------------------------------
//! MULTIPLICATION between time and power.
pw_energy operator*(const sc_core::sc_time&,
                    const pw_power&);

// ---------------------------------------------------------------------------
//! DIVISION of energy by time.
pw_power operator/(const pw_energy&,
                   const sc_core::sc_time&);

// ---------------------------------------------------------------------------
//! DIVISION of energy by power.
sc_core::sc_time operator/(const pw_energy&,
                           const pw_power&);


} // namespace sc_pwr


#endif // _PW_PHYSICAL_OPERATORS_
