// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_phase.h,v 1.1 2011/06/30 08:53:15 my294 Exp $

/** @file pw_phase.h
 * @brief Define different kinds of power phase which can be used by a System 
 * Component.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 */

#ifndef _PW_PHASE_
#define _PW_PHASE_



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
// POWER PHASE CODE

//! Power phase INIT
extern const char* PW_PHASE_INIT;          // "INIT"
//! Power phase IDLE
extern const char* PW_PHASE_IDLE;          // "IDLE"
//! Power phase WAIT
extern const char* PW_PHASE_WAIT;          // "WAIT"
//! Power phase PROCEED
extern const char* PW_PHASE_PROCEED;       // "PROCEED"
//! Power phase SEND
extern const char* PW_PHASE_SEND;          // "SEND"
//! Power phase READ
extern const char* PW_PHASE_READ;          // "READ"
//! Power phase WRITE
extern const char* PW_PHASE_WRITE;         // "WRITE"
//! Power phase RECEIVE
extern const char* PW_PHASE_RECEIVE;       // "RECEIVE"
//! Power phase SEND_RECEIVE
extern const char* PW_PHASE_SEND_RECEIVE;  // "SEND_RECEIVE"
//! Power phase COMMUNICATE
extern const char* PW_PHASE_COMMUNICATE;   // "COMMUNICATE"
//! Power phase CONFIG
extern const char* PW_PHASE_CONFIG;        // "CONFIG"
//! Power phase COMPUTE
extern const char* PW_PHASE_COMPUTE;       // "COMPUTE"
//! Power phase ROUTE
extern const char* PW_PHASE_ROUTE;         // "ROUTE"
//! Power phase INTERRUPT
extern const char* PW_PHASE_INTERRUPT;     // "INTERRUPT"
//! Power phase CHECK
extern const char* PW_PHASE_CHECK;         // "CHECK"
//! Power phase UNDEF
extern const char* PW_PHASE_UNDEF;         // "UNDEF"


} // namespace sc_pwr

#endif // _PW_PHASE_
