// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

#ifndef _PW_OBSERVER_BASE_
#define _PW_OBSERVER_BASE_


// $Id: pw_observer_base.h,v 1.2 2011/07/25 15:32:39 my294 Exp $

/** @file pw_observer_base.h
 * @brief Makes statistic on power variation.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * Base class of the tracing observer.
 */

#include <systemc>
#include "pw_observer_if.h"

// ===========================================================================
namespace sc_pwr
{

// ---------------------------------------------------------------------------
/**
 * @brief Base class of the tracing observer.
 */
class pw_observer_base:
    public pw_observer_if,
    public sc_core::sc_attr_base
{
    public: // CONSTRUCTOR AND DESTRUCTOR
        /**
         * @brief Constructor of a statistic observer.
         * @param[in] p_obj SystemC object monitored by this observer.
         * @param[in] p_att_name SystemC attribute name.
         */
        pw_observer_base(sc_core::sc_object& p_obj,
                         const std::string& p_att_name);

        // virtual destructor
        virtual ~pw_observer_base(void);

    public: // MISCELLANOUS FUNCTIONS
        //! Return an informative string about this observer.
        std::string to_string(void) const;

        //! Return the sc_object monitored by this observer.
	sc_core::sc_object& get_sc_object(void) const;

        //! Return the name of the object monitored by this observer.
        std::string get_obj_name(void) const;

        //! Return the SystemC attribute name.
        std::string get_att_name(void) const;

    protected: // ATTRIBUTES
        //! Reference on the SystemC object monitored by this observer.
        sc_core::sc_object& a_obj;

        //! SystemC attribute name of this observer.
        std::string a_att_name;
}; // pw_observer_base

    // ---------------------------------------------------------------------------
    // Output stream operator of energy object.
    std::ostream& operator<<(std::ostream&,
			     const pw_observer_base&);      
    
    //! Attach a parameter observer locally and optionally also to all lower monitored modules.
    //! If p_object is null then start at top.
    void attach_observer(pw_observer_base& p_observer,
			 sc_core::sc_object* p_pos,
			 bool p_attach_to_children
			 );
  
  
  
} // namespace sc_pwr

#endif // _PW_OBSERVER_BASE_
