// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_kernel_ids.h,v 1.2 2011/07/25 15:32:39 my294 Exp $

/** @file pw_kernel_ids.h
 * @brief Define error messages for the pwr library
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * Reports ids in the range 0-99
 *
 */

#ifndef _PW_KERNEL_IDS_
#define _PW_KERNEL_IDS_



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
// POWER ERROR CODES

//! /cea/pwr/kernel/0
extern const char* PW_POWER_UNIT_OVERFLOW_TYPE_;
//! Overflow with pw_power_unit data.
extern const char* PW_POWER_UNIT_OVERFLOW_MSG_;

//! /cea/pwr/kernel/1
extern const char* PW_POWER_OVERFLOW_TYPE_;
//! Overflow with pw_power data.
extern const char* PW_POWER_OVERFLOW_MSG_;

//! /cea/pwr/kernel/34
extern const char* PW_POWER_UNDERFLOW_TYPE_;
//! Underflow with pw_power data.
extern const char* PW_POWER_UNDERFLOW_MSG_;

//! /cea/pwr/kernel/2
extern const char* PW_POWER_DIVISION_BY_ZERO_TYPE_;
//! Division by zero not allowed with pw_power.
extern const char* PW_POWER_DIVISION_BY_ZERO_MSG_;

//! /cea/pwr/kernel/3
extern const char* PW_POWER_RESOLUTION_ELABORATION_TYPE_;
//! Power resolution can only be set during elaboration phase.
extern const char* PW_POWER_RESOLUTION_ELABORATION_MSG_;

//! /cea/pwr/kernel/4
extern const char* PW_POWER_RESOLUTION_FIXED_TYPE_;
//! Power resolution already fixed.
extern const char* PW_POWER_RESOLUTION_FIXED_MSG_;

//! /cea/pwr/kernel/5
extern const char* PW_POWER_RESOLUTION_POW10_TYPE_;
//! Power resolution value must be a power of 10.
extern const char* PW_POWER_RESOLUTION_POW10_MSG_;

//! /cea/pwr/kernel/6
extern const char* PW_POWER_NEGATIVE_TYPE_;
//! Power value must be positive.
extern const char* PW_POWER_NEGATIVE_MSG_;

//! /cea/pwr/kernel/7
extern const char* PW_POWER_RESOLUTION_ZERO_TYPE_;
//! Power resolution value must be greater than zero.
extern const char* PW_POWER_RESOLUTION_ZERO_MSG_;

//! /cea/pwr/kernel/8
extern const char* PW_POWER_RESOLUTION_NEGATIVE_TYPE_;
//! Power resolution value must be a positive.
extern const char* PW_POWER_RESOLUTION_NEGATIVE_MSG_;

//! /cea/pwr/kernel/9
extern const char* PW_POWER_RESOLUTION_OVERFLOW_TYPE_;
//! Overflow with power resolution value.
extern const char* PW_POWER_RESOLUTION_OVERFLOW_MSG_;

//! /cea/pwr/kernel/21
extern const char* PW_POWER_UNIT_OSTREAM_ERROR_TYPE_;
//! Failed to initialize input stream.
extern const char* PW_POWER_UNIT_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/22
extern const char* PW_POWER_OSTREAM_ERROR_TYPE_;
//! Failed to initialize output stream.
extern const char* PW_POWER_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/28
extern const char* PW_POWER_ISTREAM_ERROR_TYPE_;
//! Failed to extract power value from input stream.
extern const char* PW_POWER_ISTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/29
extern const char* PW_POWER_UNIT_ISTREAM_ERROR_TYPE_;
//! Failed to extract power unit from input stream.
extern const char* PW_POWER_UNIT_ISTREAM_ERROR_MSG_;

// ---------------------------------------------------------------------------
// VOLTAGE ERROR CODES

//! /cea/pwr/kernel/40
extern const char* PW_VOLTAGE_UNIT_OVERFLOW_TYPE_;
//! Overflow with pw_voltage_unit data.
extern const char* PW_VOLTAGE_UNIT_OVERFLOW_MSG_;

//! /cea/pwr/kernel/41
extern const char* PW_VOLTAGE_OVERFLOW_TYPE_;
//! Overflow with pw_voltage data.
extern const char* PW_VOLTAGE_OVERFLOW_MSG_;

//! /cea/pwr/kernel/50
extern const char* PW_VOLTAGE_UNDERFLOW_TYPE_;
//! Underflow with pw_voltage data.
extern const char* PW_VOLTAGE_UNDERFLOW_MSG_;

//! /cea/pwr/kernel/42
extern const char* PW_VOLTAGE_DIVISION_BY_ZERO_TYPE_;
//! Division by zero not allowed with pw_voltage.
extern const char* PW_VOLTAGE_DIVISION_BY_ZERO_MSG_;

//! /cea/pwr/kernel/43
extern const char* PW_VOLTAGE_RESOLUTION_ELABORATION_TYPE_;
//! voltage resolution can only be set during elaboration phase.
extern const char* PW_VOLTAGE_RESOLUTION_ELABORATION_MSG_;

//! /cea/pwr/kernel/44
extern const char* PW_VOLTAGE_RESOLUTION_FIXED_TYPE_;
//! voltage resolution already fixed.
extern const char* PW_VOLTAGE_RESOLUTION_FIXED_MSG_;

//! /cea/pwr/kernel/45
extern const char* PW_VOLTAGE_RESOLUTION_POW10_TYPE_;
//! Power resolution value must be a power of 10.
extern const char* PW_VOLTAGE_RESOLUTION_POW10_MSG_;

//! /cea/pwr/kernel/46
extern const char* PW_VOLTAGE_NEGATIVE_TYPE_;
//! voltage value must be positive.
extern const char* PW_VOLTAGE_NEGATIVE_MSG_;

//! /cea/pwr/kernel/47
extern const char* PW_VOLTAGE_RESOLUTION_ZERO_TYPE_;
//! voltage resolution value must be greater than zero.
extern const char* PW_VOLTAGE_RESOLUTION_ZERO_MSG_;

//! /cea/pwr/kernel/48
extern const char* PW_VOLTAGE_RESOLUTION_NEGATIVE_TYPE_;
//! voltage resolution value must be a positive.
extern const char* PW_VOLTAGE_RESOLUTION_NEGATIVE_MSG_;

//! /cea/pwr/kernel/49
extern const char* PW_VOLTAGE_RESOLUTION_OVERFLOW_TYPE_;
//! Overflow with voltage resolution value.
extern const char* PW_VOLTAGE_RESOLUTION_OVERFLOW_MSG_;

//! /cea/pwr/kernel/51
extern const char* PW_VOLTAGE_UNIT_OSTREAM_ERROR_TYPE_;
//! Failed to initialize input stream.
extern const char* PW_VOLTAGE_UNIT_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/52
extern const char* PW_VOLTAGE_OSTREAM_ERROR_TYPE_;
//! Failed to initialize output stream.
extern const char* PW_VOLTAGE_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/53
extern const char* PW_VOLTAGE_ISTREAM_ERROR_TYPE_;
//! Failed to extract voltage value from input stream.
extern const char* PW_VOLTAGE_ISTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/54
extern const char* PW_VOLTAGE_UNIT_ISTREAM_ERROR_TYPE_;
//! Failed to extract voltage unit from input stream.
extern const char* PW_VOLTAGE_UNIT_ISTREAM_ERROR_MSG_;


// ---------------------------------------------------------------------------
// LENGTH ERROR CODES

//! /cea/pwr/kernel/55
extern const char* PW_LENGTH_UNIT_OVERFLOW_TYPE_;
//! Overflow with pw_length_unit data.
extern const char* PW_LENGTH_UNIT_OVERFLOW_MSG_;

//! /cea/pwr/kernel/56
extern const char* PW_LENGTH_OVERFLOW_TYPE_;
//! Overflow with pw_length data.
extern const char* PW_LENGTH_OVERFLOW_MSG_;

//! /cea/pwr/kernel/57
extern const char* PW_LENGTH_UNDERFLOW_TYPE_;
//! Underflow with pw_length data.
extern const char* PW_LENGTH_UNDERFLOW_MSG_;

//! /cea/pwr/kernel/58
extern const char* PW_LENGTH_DIVISION_BY_ZERO_TYPE_;
//! Division by zero not allowed with pw_length.
extern const char* PW_LENGTH_DIVISION_BY_ZERO_MSG_;

//! /cea/pwr/kernel/59
extern const char* PW_LENGTH_RESOLUTION_ELABORATION_TYPE_;
//! length resolution can only be set during elaboration phase.
extern const char* PW_LENGTH_RESOLUTION_ELABORATION_MSG_;

//! /cea/pwr/kernel/60
extern const char* PW_LENGTH_RESOLUTION_FIXED_TYPE_;
//! length resolution already fixed.
extern const char* PW_LENGTH_RESOLUTION_FIXED_MSG_;

//! /cea/pwr/kernel/61
extern const char* PW_LENGTH_RESOLUTION_POW10_TYPE_;
//! Length resolution value must be a power of 10.
extern const char* PW_LENGTH_RESOLUTION_POW10_MSG_;

//! /cea/pwr/kernel/62
extern const char* PW_LENGTH_NEGATIVE_TYPE_;
//! length value must be positive.
extern const char* PW_LENGTH_NEGATIVE_MSG_;

//! /cea/pwr/kernel/63
extern const char* PW_LENGTH_RESOLUTION_ZERO_TYPE_;
//! length resolution value must be greater than zero.
extern const char* PW_LENGTH_RESOLUTION_ZERO_MSG_;

//! /cea/pwr/kernel/64
extern const char* PW_LENGTH_RESOLUTION_NEGATIVE_TYPE_;
//! length resolution value must be a positive.
extern const char* PW_LENGTH_RESOLUTION_NEGATIVE_MSG_;

//! /cea/pwr/kernel/65
extern const char* PW_LENGTH_RESOLUTION_OVERFLOW_TYPE_;
//! Overflow with length resolution value.
extern const char* PW_LENGTH_RESOLUTION_OVERFLOW_MSG_;

//! /cea/pwr/kernel/66
extern const char* PW_LENGTH_UNIT_OSTREAM_ERROR_TYPE_;
//! Failed to initialize input stream.
extern const char* PW_LENGTH_UNIT_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/67
extern const char* PW_LENGTH_OSTREAM_ERROR_TYPE_;
//! Failed to initialize output stream.
extern const char* PW_LENGTH_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/68
extern const char* PW_LENGTH_ISTREAM_ERROR_TYPE_;
//! Failed to extract length value from input stream.
extern const char* PW_LENGTH_ISTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/69
extern const char* PW_LENGTH_UNIT_ISTREAM_ERROR_TYPE_;
//! Failed to extract length unit from input stream.
extern const char* PW_LENGTH_UNIT_ISTREAM_ERROR_MSG_;

// ---------------------------------------------------------------------------
// AREA ERROR CODES

//! /cea/pwr/kernel/78
extern const char* PW_AREA_UNIT_OVERFLOW_TYPE_;
//! Overflow with pw_area_unit data.
extern const char* PW_AREA_UNIT_OVERFLOW_MSG_;

//! /cea/pwr/kernel/68
extern const char* PW_AREA_OVERFLOW_TYPE_;
//! Overflow with pw_area data.
extern const char* PW_AREA_OVERFLOW_MSG_;

//! /cea/pwr/kernel/70
extern const char* PW_AREA_UNDERFLOW_TYPE_;
//! Underflow with pw_area data.
extern const char* PW_AREA_UNDERFLOW_MSG_;

//! /cea/pwr/kernel/71
extern const char* PW_AREA_DIVISION_BY_ZERO_TYPE_;
//! Division by zero not allowed with pw_area.
extern const char* PW_AREA_DIVISION_BY_ZERO_MSG_;

//! /cea/pwr/kernel/72
extern const char* PW_AREA_RESOLUTION_ELABORATION_TYPE_;
//! area resolution can only be set during elaboration phase.
extern const char* PW_AREA_RESOLUTION_ELABORATION_MSG_;

//! /cea/pwr/kernel/73
extern const char* PW_AREA_RESOLUTION_FIXED_TYPE_;
//! area resolution already fixed.
extern const char* PW_AREA_RESOLUTION_FIXED_MSG_;

//! /cea/pwr/kernel/74
extern const char* PW_AREA_RESOLUTION_POW10_TYPE_;
//! Area resolution value must be a power of 10.
extern const char* PW_AREA_RESOLUTION_POW10_MSG_;

//! /cea/pwr/kernel/75
extern const char* PW_AREA_NEGATIVE_TYPE_;
//! area value must be positive.
extern const char* PW_AREA_NEGATIVE_MSG_;

//! /cea/pwr/kernel/76
extern const char* PW_AREA_RESOLUTION_ZERO_TYPE_;
//! area resolution value must be greater than zero.
extern const char* PW_AREA_RESOLUTION_ZERO_MSG_;

//! /cea/pwr/kernel/77
extern const char* PW_AREA_RESOLUTION_NEGATIVE_TYPE_;
//! area resolution value must be a positive.
extern const char* PW_AREA_RESOLUTION_NEGATIVE_MSG_;

//! /cea/pwr/kernel/78
extern const char* PW_AREA_RESOLUTION_OVERFLOW_TYPE_;
//! Overflow with area resolution value.
extern const char* PW_AREA_RESOLUTION_OVERFLOW_MSG_;

//! /cea/pwr/kernel/79
extern const char* PW_AREA_UNIT_OSTREAM_ERROR_TYPE_;
//! Failed to initialize input stream.
extern const char* PW_AREA_UNIT_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/80
extern const char* PW_AREA_OSTREAM_ERROR_TYPE_;
//! Failed to initialize output stream.
extern const char* PW_AREA_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/81
extern const char* PW_AREA_ISTREAM_ERROR_TYPE_;
//! Failed to extract area value from input stream.
extern const char* PW_AREA_ISTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/82
extern const char* PW_AREA_UNIT_ISTREAM_ERROR_TYPE_;
//! Failed to extract area unit from input stream.
extern const char* PW_AREA_UNIT_ISTREAM_ERROR_MSG_;


// ---------------------------------------------------------------------------

// ---------------------------------------------------------------------------
// ENERGY ERROR CODES

extern const char* PW_ENERGY_UNIT_UNDERFLOW_MSG_;
//! /cea/pwr/kernel/93
extern const char* PW_ENERGY_UNIT_UNDERFLOW_TYPE_;
//! Underflow with pw_energy_unit data.

extern const char* PW_ENERGY_UNIT_OVERFLOW_MSG_;
//! /cea/pwr/kernel/10
extern const char* PW_ENERGY_UNIT_OVERFLOW_TYPE_;
//! Overflow with pw_energy_unit data.
extern const char* PW_ENERGY_UNIT_OVERFLOW_MSG_;

//! /cea/pwr/kernel/11
extern const char* PW_ENERGY_OVERFLOW_TYPE_;
//! Overflow with pw_energy data.
extern const char* PW_ENERGY_OVERFLOW_MSG_;

//! /cea/pwr/kernel/35
extern const char* PW_ENERGY_UNDERFLOW_TYPE_;
//! Underflow with pw_energy data.
extern const char* PW_ENERGY_UNDERFLOW_MSG_;

//! /cea/pwr/kernel/12
extern const char* PW_ENERGY_DIVISION_BY_ZERO_TYPE_;
//! Division by zero not allowed with pw_energy.
extern const char* PW_ENERGY_DIVISION_BY_ZERO_MSG_;

//! /cea/pwr/kernel/13
extern const char* PW_ENERGY_RESOLUTION_ELABORATION_TYPE_;
//! Energy resolution can only be set during elaboration phase.
extern const char* PW_ENERGY_RESOLUTION_ELABORATION_MSG_;

//! /cea/pwr/kernel/14
extern const char* PW_ENERGY_RESOLUTION_FIXED_TYPE_;
//! Energy resolution already fixed.
extern const char* PW_ENERGY_RESOLUTION_FIXED_MSG_;

//! /cea/pwr/kernel/15
extern const char* PW_ENERGY_RESOLUTION_POW10_TYPE_;
//! Energy resolution value must be a energy of 10.
extern const char* PW_ENERGY_RESOLUTION_POW10_MSG_;

//! /cea/pwr/kernel/16
extern const char* PW_ENERGY_NEGATIVE_TYPE_;
//! Energy value must be positive.
extern const char* PW_ENERGY_NEGATIVE_MSG_;

//! /cea/pwr/kernel/17
extern const char* PW_ENERGY_RESOLUTION_ZERO_TYPE_;
//! Energy resolution value must be greater than zero.
extern const char* PW_ENERGY_RESOLUTION_ZERO_MSG_;

//! /cea/pwr/kernel/18
extern const char* PW_ENERGY_RESOLUTION_NEGATIVE_TYPE_;
//! Energy resolution value must be a positive.
extern const char* PW_ENERGY_RESOLUTION_NEGATIVE_MSG_;

//! /cea/pwr/kernel/19
extern const char* PW_ENERGY_RESOLUTION_OVERFLOW_TYPE_;
//! Overflow with energy resolution value.
extern const char* PW_ENERGY_RESOLUTION_OVERFLOW_MSG_;

//! /cea/pwr/kernel/23
extern const char* PW_ENERGY_UNIT_OSTREAM_ERROR_TYPE_;
//! Failed to initialize input stream.
extern const char* PW_ENERGY_UNIT_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/24
extern const char* PW_ENERGY_OSTREAM_ERROR_TYPE_;
//! Failed to initialize output stream.
extern const char* PW_ENERGY_OSTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/30
extern const char* PW_ENERGY_ISTREAM_ERROR_TYPE_;
//! Failed to extract energy value from input stream.
extern const char* PW_ENERGY_ISTREAM_ERROR_MSG_;

//! /cea/pwr/kernel/31
extern const char* PW_ENERGY_UNIT_ISTREAM_ERROR_TYPE_;
//! Failed to extract energy unit from input stream.
extern const char* PW_ENERGY_UNIT_ISTREAM_ERROR_MSG_;


// ---------------------------------------------------------------------------
// PHYSICAL OPERATORS ERROR CODES

//! /cea/pwr/kernel/20
extern const char* PW_PHYS_DIVISION_BY_ZERO_TYPE_;
//! Division by zero not allowed.
extern const char* PW_PHYS_DIVISION_BY_ZERO_MSG_;


// ---------------------------------------------------------------------------
// POWER MODULES ERROR CODES

//! /cea/pwr/kernel/26
extern const char* PW_MODULE_ATTRIBUTE_ID_OVERFLOW_TYPE_;
//! Overflow with pw_module_base::attribute_id data.
extern const char* PW_MODULE_ATTRIBUTE_ID_OVERFLOW_MSG_;

//! /cea/pwr/kernel/27
extern const char* PW_MODULE_DYNAMIC_CAST_FAILURE_TYPE_;
//! Power module must be an sc_object.
extern const char* PW_MODULE_DYNAMIC_CAST_FAILURE_MSG_;

//! /cea/pwr/kernel/32
extern const char* PW_UNDEF_MODE_PHASE_TYPE_;
//! Unknown power mode: failed to switch from 
extern const char* PW_UNDEF_MODE_PHASE_MSG_;


// ---------------------------------------------------------------------------
// BASE OBSERVER ERROR CODES

//! /cea/pwr/kernel/33
extern const char* PW_UNRECORDED_OBSERVER_TYPE_;
//! Try to destroy unrecorded statisitic observer.
extern const char* PW_UNRECORDED_OBSERVER_MSG_;


// ---------------------------------------------------------------------------
// MISCELLEANOUS ERROR CODES

//! /cea/pwr/kernel/25
extern const char* PW_KERNEL_OSTREAM_ERROR_TYPE_;
//! Failed to initialize output stream.
extern const char* PW_KERNEL_OSTREAM_ERROR_MSG_;


} // namespace sc_pwr

#endif // _PW_KERNEL_IDS_
