// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: tlm_power.h,v 1.2 2011/07/25 15:32:39 my294 Exp $

/** @file tlm_power.h
 * @brief Header file of the SystemC Power library.
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 * @note This file is the wrapper of the pwr header allowing to not define the 
 * namespace sc_pwr.
 */

 
#ifndef _TLM_POWER_H_INCLUDED_
#define _TLM_POWER_H_INCLUDED_

#include "tlm_power"

/** @namespace sc_pwr
 * @brief Namespace of the SystemC Power library.
 */

using sc_pwr::pw_module;
using sc_pwr::pw_module_base;

using sc_pwr::pw_trace_file;
using sc_pwr::pw_create_txt_trace_file;
using sc_pwr::pw_close_txt_trace_file;
using sc_pwr::pw_create_vcd_trace_file;
using sc_pwr::pw_close_vcd_trace_file;
using sc_pwr::pw_create_slk_trace_file;
using sc_pwr::pw_close_slk_trace_file;
using sc_pwr::pw_trace;
using sc_pwr::pw_set_time_unit;
using sc_pwr::pw_write_comment;

using sc_pwr::pw_energy;
using sc_pwr::pw_energy_unit;
using sc_pwr::pw_set_energy_resolution;
using sc_pwr::pw_get_energy_resolution;
using sc_pwr::PW_fJ;
using sc_pwr::PW_pJ;
using sc_pwr::PW_nJ;
using sc_pwr::PW_uJ;
using sc_pwr::PW_mJ;
using sc_pwr::PW_JOULE;
using sc_pwr::PW_ZERO_ENERGY;

using sc_pwr::pw_voltage;
using sc_pwr::pw_voltage_unit;
using sc_pwr::pw_set_voltage_resolution;
using sc_pwr::pw_get_voltage_resolution;
using sc_pwr::PW_fV;
using sc_pwr::PW_pV;
using sc_pwr::PW_nV;
using sc_pwr::PW_uV;
using sc_pwr::PW_mV;
using sc_pwr::PW_VOLT;
using sc_pwr::PW_ZERO_VOLT;

using sc_pwr::pw_length;
using sc_pwr::pw_length_unit;
using sc_pwr::pw_set_length_resolution;
using sc_pwr::pw_get_length_resolution;
using sc_pwr::PW_fm;
using sc_pwr::PW_pm;
using sc_pwr::PW_nm;
using sc_pwr::PW_um;
using sc_pwr::PW_mm;
using sc_pwr::PW_METER;
using sc_pwr::PW_ZERO_LENGTH;

using sc_pwr::PW_squm;
using sc_pwr::PW_sqmm;
using sc_pwr::PW_sqcm;
using sc_pwr::PW_sqm;
using sc_pwr::PW_ZERO_AREA;

using sc_pwr::pw_power;
using sc_pwr::pw_power_unit;
using sc_pwr::pw_set_power_resolution;
using sc_pwr::pw_get_power_resolution;
using sc_pwr::PW_fW;
using sc_pwr::PW_pW;
using sc_pwr::PW_nW;
using sc_pwr::PW_uW;
using sc_pwr::PW_mW;
using sc_pwr::PW_WATT;
using sc_pwr::PW_ZERO_POWER;


using sc_pwr::PW_MODE_ON;
using sc_pwr::PW_MODE_OFF;
using sc_pwr::PW_MODE_UNDEF;

using sc_pwr::PW_PHASE_INIT;
using sc_pwr::PW_PHASE_IDLE;
using sc_pwr::PW_PHASE_WAIT;
using sc_pwr::PW_PHASE_PROCEED;
using sc_pwr::PW_PHASE_SEND;
using sc_pwr::PW_PHASE_READ;
using sc_pwr::PW_PHASE_WRITE;
using sc_pwr::PW_PHASE_RECEIVE;
using sc_pwr::PW_PHASE_SEND_RECEIVE;
using sc_pwr::PW_PHASE_COMMUNICATE;
using sc_pwr::PW_PHASE_CONFIG;
using sc_pwr::PW_PHASE_COMPUTE;
using sc_pwr::PW_PHASE_ROUTE;
using sc_pwr::PW_PHASE_INTERRUPT;
using sc_pwr::PW_PHASE_CHECK;
using sc_pwr::PW_PHASE_UNDEF;


#endif // _TLM_POWER_H_INCLUDED_
