package uk.ac.cam.rkh23.DP2013.Proxy;

import uk.ac.cam.rkh23.DP2013.Singleton.DatabaseConn;

public class CustomerProxy implements Customer {

	private String mCachedName;
	
	public CustomerProxy(String name) {
		mCachedName=name;
	}
	
	public String getName() {
		// return the cached (local) version
		return mCachedName;
	}
	
	public int getPIN() {
		// Load in the full details only if we need them
		FullCustomer actual = DatabaseConn.getCustomer(mCachedName);
		return actual.getPIN();
	}
	

}
