/*
 * Decompiled with CFR 0.152.
 */
package ttcasm.comparch.cl.cam.ac.uk;

import java.io.IOException;
import java.io.Writer;
import ttcasm.comparch.cl.cam.ac.uk.Generator;

public class MIFGenerator
extends Generator {
    private int addr = 0;

    protected MIFGenerator(Writer writer) throws IOException {
        super(writer);
        writer.write("DEPTH = 1024;            -- The size of memory in words\n");
        writer.write("WIDTH = 32;              -- The size of data in bits\n");
        writer.write("ADDRESS_RADIX = HEX;     -- The radix for address values\n");
        writer.write("DATA_RADIX = BIN;        -- The radix for data values\n");
        writer.write("CONTENT                  -- Start of (address : data) pairs\n");
        writer.write("BEGIN\n\n");
    }

    @Override
    protected void writeHeader() throws IOException {
        this.w.write(Integer.toHexString(this.addr) + " : ");
    }

    @Override
    protected void write(int n, int n2) throws IOException {
        String string = Integer.toBinaryString(n);
        String string2 = "";
        for (int i = 0; i < n2 - string.length(); ++i) {
            string2 = string2 + "0";
        }
        this.w.write(string2 + string);
    }

    @Override
    protected void writeFooter() throws IOException {
        this.w.write(";\n");
        ++this.addr;
    }

    @Override
    protected void close() throws IOException {
        while (this.addr < 1024) {
            this.w.write(Integer.toHexString(this.addr) + " : ");
            this.write(0, 32);
            this.w.write(";\n");
            ++this.addr;
        }
        this.w.write("\nEND;");
        this.w.close();
    }
}

