/*
 * Decompiled with CFR 0.152.
 */
package ttcasm.comparch.cl.cam.ac.uk;

import ttcasm.comparch.cl.cam.ac.uk.Generator;
import ttcasm.comparch.cl.cam.ac.uk.Instruction;
import ttcasm.comparch.cl.cam.ac.uk.Program;

public class IJmp
implements Instruction {
    private byte rw;
    private byte ra;
    private byte rb;
    private Instruction.Func func;
    private Instruction.Rotate rotate;

    protected IJmp(byte by, byte by2, byte by3, Instruction.Func func, Instruction.Rotate rotate) {
        this.rw = by;
        this.ra = by2;
        this.rb = by3;
        this.func = func;
        this.rotate = rotate;
    }

    @Override
    public void Validate(Program program) throws Exception {
        if (this.rw < 0 | this.ra < 0 | this.rb < 0) {
            throw new Exception("Invalid register (index not in range [0..127]) ");
        }
        if (this.rw > 127 | this.ra > 127 | this.rb > 127) {
            throw new Exception("Invalid register (index not in range [0..127]) ");
        }
    }

    @Override
    public void Generate(Generator generator) throws Exception {
        generator.writeHeader();
        generator.write(this.rw, 7);
        generator.write(0, 1);
        generator.write(this.ra, 7);
        generator.write(this.rb, 7);
        generator.write(this.func.ordinal(), 3);
        generator.write(this.rotate.ordinal(), 2);
        generator.write(Instruction.Skip.noskip.ordinal(), 2);
        generator.write(Instruction.Opcode.jmp.ordinal(), 3);
        generator.writeFooter();
    }

    @Override
    public String toString() {
        return (Object)((Object)Instruction.Opcode.jmp) + " RW=" + this.rw + " RA=" + this.ra + " RB=" + this.rb + " FUNC=" + (Object)((Object)this.func) + " ROTATE=" + (Object)((Object)this.rotate);
    }
}

