/*
 * Decompiled with CFR 0.152.
 */
package ttcasm.comparch.cl.cam.ac.uk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java_cup.runtime.Symbol;
import ttcasm.comparch.cl.cam.ac.uk.Instruction;
import ttcasm.comparch.cl.cam.ac.uk.MIFGenerator;
import ttcasm.comparch.cl.cam.ac.uk.Parser;
import ttcasm.comparch.cl.cam.ac.uk.Program;
import ttcasm.comparch.cl.cam.ac.uk.RMBGenerator;
import ttcasm.comparch.cl.cam.ac.uk.Scanner;

public abstract class Generator {
    Writer w;

    protected Generator(Writer writer) throws IOException, IllegalArgumentException {
        this.w = writer;
    }

    protected abstract void writeHeader() throws IOException;

    protected abstract void write(int var1, int var2) throws IOException, IllegalArgumentException;

    protected abstract void writeFooter() throws IOException;

    protected abstract void close() throws IOException;

    public static void main(String[] stringArray) {
        try {
            Generator generator;
            FileWriter fileWriter;
            Object object;
            System.out.println("Info (General): TTC Assembler (Ben Thorner, August 2012)");
            if (stringArray.length == 0) {
                throw new Exception("java -jar ttcasm.jar (help | display | rmb | mif) [<input file>]");
            }
            Parser parser = stringArray.length == 1 ? new Parser(new Scanner(System.in)) : new Parser(new Scanner(new FileInputStream(stringArray[1])));
            if (!(stringArray[0].equals("display") | stringArray[0].equals("rmb") | stringArray[0].equals("mif"))) {
                System.out.println("Info (General): java -jar ttcasm.jar (help | display | rmb | mif) [<input file>]");
                System.exit(-1);
            }
            Symbol symbol = parser.parse();
            if (symbol.value == null) {
                throw new NullPointerException("Invalid program");
            }
            Program program = (Program)symbol.value;
            for (Object object2 : program) {
                object2.Validate(program);
            }
            if (stringArray[0].equals("display")) {
                for (Object object2 : program) {
                    System.out.println("\t" + object2);
                }
            }
            if (stringArray[0].equals("rmb")) {
                Object object2;
                object = "output";
                if (stringArray.length > 1) {
                    int n = stringArray[1].lastIndexOf(46);
                    object = stringArray[1].substring(0, n < 0 ? stringArray[1].length() : n);
                }
                object2 = new File((String)object + ".rmb");
                try {
                    fileWriter = new FileWriter((File)object2);
                    generator = new RMBGenerator(fileWriter);
                    for (Instruction instruction : (Program)symbol.value) {
                        instruction.Generate(generator);
                    }
                    generator.close();
                }
                catch (Exception exception) {
                    try {
                        ((File)object2).delete();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    throw exception;
                }
            }
            if (stringArray[0].equals("mif")) {
                object = "output";
                if (stringArray.length > 1) {
                    int n = stringArray[1].lastIndexOf(46);
                    object = stringArray[1].substring(0, n < 0 ? stringArray[1].length() : n);
                }
                File file = new File((String)object + ".mif");
                try {
                    fileWriter = new FileWriter(file);
                    generator = new MIFGenerator(fileWriter);
                    for (Instruction instruction : (Program)symbol.value) {
                        instruction.Generate(generator);
                    }
                    generator.close();
                }
                catch (Exception exception) {
                    try {
                        file.delete();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    throw exception;
                }
            }
            System.out.println("Info (General): Program terminated (no errors)");
        }
        catch (Exception exception) {
            System.err.println("Error (General): " + exception.getMessage());
            System.exit(-1);
        }
    }
}

