
  type label = Temp.label

(* tgg22: added to Appel's Tree file: 

   -- constructor CLOSURE : to handle functions as values 
   -- types fundef and prog :  to eliminate need for Appel's Frame module 
   -- type tree_rep : called "exp" in Appel's book where it is in file Translate.sml
   -- functions unEx, unCx, unNx : in Appel's Translate.sml 
   -- pretty printing functions for verbose mode 
*) 
 
  datatype stm  = SEQ of stm * stm
                | LABEL of label
                | JUMP of exp * label list
                | CJUMP of relop * exp * exp * label * label
                | MOVE of exp * exp
                | EXP of exp

      and exp   = BINOP of binop * exp * exp
                | MEM of exp
                | TEMP of Temp.temp
                | ESEQ of stm * exp
                | NAME of label
                | CONST of int
                | CALL of exp * (exp list)
                | CLOSURE of Temp.label * (exp list)

      and binop = PLUS | MINUS | MUL | DIV 
                | AND | OR | LSHIFT | RSHIFT | ARSHIFT | XOR

      and relop = EQ | NE | LT | GT | LE | GE 
                | ULT | ULE | UGT | UGE

  datatype fundef = FunDecl of 
         Temp.label         (* name *) 
         * Temp.temp        (* formal parameter *) 
         * (Temp.temp list) (* environment *) 
         * (Temp.temp list) (* local (let-bound) variables *) 
         * stm              (* body *) 

  datatype prog = Prog of (fundef list) * Temp.label 


  (* tgg22: 
     Motivation: Here is a rough explanation. 
      Tree.stm : evaluate for "side effect". 
      Tree.exp : evaluate for a "value". 

     Our translation from AST_expr.expr to Tree.stm/Tree.exp 
     will use the following intermediate representation, called 
     tree_rep (called "exp" in Appel's book where it is in file Translate.sml). 
     This helps us bridge the gap between the language of expressions 
     in AST_expr.expr and the statement/expression distinction that makes
     more sense at a lower level of abstraction. 

     The Cx constructor may require some explanation.   The tree_rep 
     (Cx f) represents the evaluation of some boolean expresson e. 
     If t is a label to jump to if e is true, and f is a label to 
     jump to if e is false, then "f(t, f)" will be a state that
     (somehow) evaluates e and jumps to the correct label. 
  *) 
  datatype tree_rep  = Ex of exp
                     | Nx of stm
                     | Cx of Temp.label * Temp.label -> stm

  (* The file Translate.sml will use the following three functions 
     to "coerce" a tree rep into the correct form. 

     For a detailed explanation see Appel (ML version), Chapter 7, pages 
     152 -- 154. 

     The only combination that will fail is "unCx(Nx stm)", which should 
     never happen since Cx's are derived from boolean conditions, which 
     are never "statements" in our language (I hope!). 
  *) 


  val unEx : tree_rep -> exp
  val unNx : tree_rep -> stm
  val unCx : tree_rep -> (Temp.label * Temp.label -> stm)

  (* tgg22 : added for pretty-printing in verbose mode *) 
  val pp_stm : stm -> unit 
  val pp_exp : exp -> unit 
  val pp_tree_rep : tree_rep -> unit 
  val pp_prog : prog -> unit 


