(* wrapper for Parser.main *) 

exception ParseError of string 

fun syntax_err () = raise (ParseError "\nSyntax Error\n")
     
fun parse (in_stream, lexbuf) = 
    let 
        val result = (Parser.main Lexer.token lexbuf)
            handle
	    Parsing.ParseError f =>
	    let val pos1 = Lexing.getLexemeStart lexbuf
		val pos2 = Lexing.getLexemeEnd lexbuf
	    in
		Location.errMsg ("", in_stream, lexbuf) 
		                (Location.Loc(pos1, pos2))
		                " parsing error."
                                handle (Fail _) => syntax_err() ;
                syntax_err() 
	    end
	  | Lexer.LexicalError(msg, pos1, pos2) =>
	    if pos1 >= 0 andalso pos2 >= 0 then
		Location.errMsg ("", in_stream, lexbuf)
		                (Location.Loc(pos1, pos2))
		                (" lexical error: " ^ msg)
                                handle (Fail _) => syntax_err() 
	    else 
		(Location.errPrompt 
                     (" lexical error: " ^ msg ^ "\n\n");
		     syntax_err() 
                           )
        val _ = Parsing.clearParser() 
    in
        result
    end


