(* alpha convert expression so that all bound variables are unique *) 

fun find env v = (Library.lookup(env, v)) handle _ => v

fun conv env (AST_expr.Skip)              = AST_expr.Skip 
  | conv env (AST_expr.Integer n)         = AST_expr.Integer n 
  | conv env (AST_expr.Boolean b)         = AST_expr.Boolean b 
  | conv env (AST_expr.Deref e)           = AST_expr.Deref (conv env e)
  | conv env (AST_expr.UnaryOp (uop, e))  = AST_expr.UnaryOp (uop, conv env e)
  | conv env (AST_expr.Op (oper, e1, e2)) = AST_expr.Op (oper, conv env e1, conv env e2)
  | conv env (AST_expr.Assign(e1,top,e2)) = AST_expr.Assign(conv env e1,top , conv env e2)
  | conv env (AST_expr.Seq(e1, e2))       = AST_expr.Seq(conv env e1, conv env e2)
  | conv env (AST_expr.If(e1, e2, e3))    = AST_expr.If(conv env e1, conv env e2, conv env e3)
  | conv env (AST_expr.While(e1, e2))     = AST_expr.While(conv env e1, conv env e2)
  | conv env (AST_expr.Ref e)             = AST_expr.Ref (conv env e)
  | conv env (AST_expr.App(e1, e2))       = AST_expr.App(conv env e1, conv env e2)
  | conv env (AST_expr.Var v)             = AST_expr.Var (find env v) 
  | conv env (AST_expr.Fn (x,t,e))        = 
       let val w = Temp.newtemp() 
           val env' = Library.update (env, x, w)
       in 
	   AST_expr.Fn (w,t, conv env' e) 
       end 
  | conv env (AST_expr.Let(x, t, e1, e2)) = 
       let val w = Temp.newtemp() 
           val env' = Library.update (env, x, w)
       in 
	   AST_expr.Let (w, t, conv env e1, conv env' e2) 
       end 
  | conv env (AST_expr.Letrecfn(f, fun_t, x, arg_t, e1, e2)) = 
       let val g = Temp.newtemp() 
           val w = Temp.newtemp() 
           val env_f   = Library.update (env, f, g)
           val env_f_x = Library.update (env_f, x, w)
       in 
	   AST_expr.Letrecfn (g, fun_t, w, arg_t, conv env_f_x e1, conv env_f e2) 
       end 

fun convert e  = conv Library.empty_env e  
    
