fun createLexBuf f = 
  let val s = Nonstdio.open_in_bin f 
  in 
     (s, Lexing.createLexer (fn buff => fn n => Nonstdio.buff_input s buff 0 n)) 
  end 

fun iter_simplify verbose n program = 
   if n <= 0 
   then program 
   else let val ast = Closure.simplify program
            val _ = if verbose 
                    then (print "\n\nAST after Closure.simplify : \n"; AST_closure.pp_prog ast)
                    else () 
        in iter_simplify verbose (n-1) ast end 

val iterations = 7 

fun vrm_compile fin fout = Library.internal_error "This compiler only supports VSM, use -vsm option"
fun vrm_compile_verbose fin fout =  Library.internal_error "This compiler only supports VSM, use -vsm option"

(* these functions only generate VSM assembler.  No binary is yet emitted. 
   Completing is left as an exercise ;-) 
*) 

fun vsm_compile fin fout = 
          vsm_code_gen.vsm_peep_hole 
             (vsm_code_gen.vsm_code_gen 
                (Translate.translate
                   (iter_simplify false iterations 
                      (Closure.convert 
                         (Alpha.convert 
                            (static_semantics.check_static_semantics 
                               (Parse.parse (createLexBuf  fin))))))))

fun vsm_compile_verbose fin fout = 
    let val stream_lexer = createLexBuf fin 
        val ast = Parse.parse stream_lexer 
        val _ = print "\nAST (in L1) = \n"
        val _ = AST_expr.pp_expr ast 
        val tast = static_semantics.check_static_semantics ast 
        val _ = print "\n\ntyped AST = \n"
        val _ = AST_expr.pp_expr tast 
        val tast2 = Alpha.convert tast 
        val _ = print "\n\nAST after Alpha.convert : \n"
        val _ = AST_expr.pp_expr tast2 
        val cast = Closure.convert tast2 
        val _ = print "\n\nAST after Closure.convert : \n"
        val _ = AST_closure.pp_prog cast 
        val cast_simple = iter_simplify true iterations cast 
        val tree = Translate.translate cast_simple  
        val _ = print "\n\nAST after Translate.translate : \n"
        val _ = Tree.pp_prog tree
        val assem = vsm_code_gen.vsm_code_gen tree 
        val _ = print "\n\nVSM Assembler : \n"
        val _ = print ((AST_vsm_assembler.vsm_program_to_string assem) ^ "\n")
        val opt_assem = vsm_code_gen.vsm_peep_hole assem
        val _ = print "\n\nVSM Assembler after peep-hole optimization : \n"
        val _ = print ((AST_vsm_assembler.vsm_program_to_string opt_assem) ^ "\n")
        in opt_assem end 


