
open Lexer;
open parser;
open static_semantics;

open normalise;
open vrm_code_gen; 
open vrm_assemble; 
open vrm_emit; 

open vsm_code_gen; 
open vsm_assemble; 
open vsm_emit; 


fun vrm_compile fin fout = 
    emit_vrm_bytecode fout 
       (vrm_assemble 
          (vrm_code_gen
             (normalise 
                (check_static_semantics 
                   (parse (init_lex_buffer fin))))))

fun vsm_compile fin fout = 
    emit_vsm_bytecode fout 
       (vsm_assemble 
          (vsm_peep_hole 
             (vsm_code_gen 
                (check_static_semantics 
                   (parse (init_lex_buffer fin))))))


fun vrm_compile_verbose fin fout = 
    let val lexer = init_lex_buffer fin 
        val ast = parse lexer 
        val _ = print "AST (in L1) = \n"
        val _ = pp_expr ast 
        val tast = check_static_semantics ast 
        val _ = print "\n\ntyped AST = \n"
        val _ = pp_expr tast 
        val _ = print "\n\nNormalised : \n"
        val tast_normal = normalise tast 
        val _ = pp_normal_expr tast_normal 
        val assem = vrm_code_gen  tast_normal 
        val _ = print "\n\nVRM Assembler : \n"
        val _ = print ((vrm_program_to_string assem) ^ "\n")
        val (inst_count, code) = vrm_assemble assem
        val _ = print "Intruction count = " 
        val _ = print (Int.toString inst_count) 
        val _ = print "\ncode: \n" 
        val _ = print ((vrm_bytecode_program_to_string code) ^ "\n")
    in emit_vrm_bytecode fout (inst_count, code) end 


fun vsm_compile_verbose fin fout = 
    let val lexer = init_lex_buffer fin 
        val ast = parse lexer 
        val _ = print "AST (in L1) = \n"
        val _ = pp_expr ast 
        val tast = check_static_semantics ast 
        val _ = print "\n\ntyped AST = \n"
        val _ = pp_expr tast 
        val assem = vsm_code_gen tast
        val _ = print "\n\nVSM Assembler : \n"
        val _ = print ((vsm_program_to_string assem) ^ "\n")
        val opt_assem = vsm_peep_hole assem
        val _ = print "\n\nVSM Assembler after peep-hole optimization : \n"
        val _ = print ((vsm_program_to_string opt_assem) ^ "\n")
        val (inst_count, code) = vsm_assemble opt_assem
        val _ = print "Intruction count = " 
        val _ = print (Int.toString inst_count) 
        val _ = print "\ncode: \n" 
        val _ = print ((vsm_bytecode_program_to_string code) ^ "\n")
    in emit_vsm_bytecode fout (inst_count, code) end 




