package uk.ac.cam.rkh23.Cloning;

/**
 * An example of a class containing a reference to another object
 */
public class ReferencingClass implements Cloneable {
	protected SimpleClass mRef;
	protected int mPrim;
	
	public ReferencingClass(int val) {
		mRef=new SimpleClass(val);
		mPrim=val;
	}
	
	// Make the clone() method public (default: protected)
	public Object clone() throws CloneNotSupportedException {
		// Perform an efficient shallow clone of ourself
		ReferencingClass r = (ReferencingClass)super.clone();
		// Now make the clone's reference point to a clone of its object
		r.mRef = (SimpleClass)mRef.clone();
		return r;
	}
}
