package uk.ac.cam.rkh23.BreakoutGame;

import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.LinkedList;

import javax.swing.JFrame;

public class Game extends JFrame implements WindowListener, KeyListener, CollisionHandler {

	private GamePanel mGamePanel = new GamePanel();
	private Ball mBall = new Ball(400,200,1,-1, 10);
	private HorizontalWall mBottom = new HorizontalWall(0,465,0,0,600);
	private HorizontalWall mTop = new HorizontalWall(0,10,0,0,600);
	private VerticalWall mLeft = new VerticalWall(10,0,0,0,500);
	private VerticalWall mRight = new VerticalWall(585,0,0,0,500);
	
	private Reflector mReflector = new Reflector(250,450,0,0,100);
	
	private ArrayList<Block> mBlocks = new ArrayList<Block>();
	
	private LinkedList<SolidObject> mToDelete = new LinkedList<SolidObject>();
	
	public Game() {
		setSize(600,500);
		this.addKeyListener(this);
		this.addWindowListener(this);
		this.getContentPane().add(mGamePanel, BorderLayout.CENTER);
		mGamePanel.addSprite(mBall);
		mGamePanel.addSprite(mBottom);
		mGamePanel.addSprite(mTop);
		mGamePanel.addSprite(mLeft);
		mGamePanel.addSprite(mRight);
		mGamePanel.addSprite(mReflector);
	
		mTop.registerForCollisions(new SuccessDetector());
		mBottom.registerForCollisions(new FailDetector());
		
		for (int j=0; j<5; j++) {
			for (int i=0; i<18; i++) {
				Block b = new Block(i*30+20,j*30+20,0,0,30);
				b.registerForCollisions(this);
				mBlocks.add(b);
				mGamePanel.addSprite(b);
			}
		}
		
		setVisible(true);
	}
	
	public void advance() {
		while (mToDelete.size()>0) {
			SolidObject so = mToDelete.pop();
			mGamePanel.removeSprite(so);
			mBlocks.remove(so);
		}
		
		mBall.update();
		mBottom.checkCollision(mBall);
		mTop.checkCollision(mBall);
		mLeft.checkCollision(mBall);
		mRight.checkCollision(mBall);
		mReflector.checkCollision(mBall);
		for(Block so : mBlocks) {
			so.checkCollision(mBall);
		}
		mGamePanel.repaint();
	}

	@Override
	public void windowActivated(WindowEvent arg0) {
	}
	@Override
	public void windowClosed(WindowEvent arg0) {
	}
	@Override
	public void windowClosing(WindowEvent arg0) {
			System.exit(0);
	}
	@Override
	public void windowDeactivated(WindowEvent arg0) {}
	@Override
	public void windowDeiconified(WindowEvent arg0) {}
	@Override
	public void windowIconified(WindowEvent arg0) {}
	@Override
	public void windowOpened(WindowEvent arg0) {}
	
	public static void main(String[] args) {
		Game g = new Game();
		while (true) {
			g.advance();
			try {
				Thread.sleep(5);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}

	@Override
	public void keyPressed(KeyEvent arg0) {
		if (arg0.getKeyCode()==39) mReflector.moveRightt();
		else if (arg0.getKeyCode()==37) mReflector.moveLeft();
	}

	@Override
	public void keyReleased(KeyEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void keyTyped(KeyEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void handleCollision(SolidObject o) {
		mToDelete.add(o);
	}
	
}
