(*    #StackCode Print := true; *)
(* unary record bugs *)
(* all of the following should evaluate *)

    val f = fn {x} => x;
    val g = fn () => f {x=111};
	
    val f' = fn ({x,...}:{x:int}) => x;
    val g' = fn () => f' {x=111};

    val f = fn {x,y} => x;
    val g = fn () => f {x=111,y=222};
	
    val f' = fn ({x,...}:{x:int,v:int}) => x;
    val g' = fn () => f' {x=111,v=222};

    val f = fn{1=x} => x;
    val g = fn () => f {1=111};
	
    val f' = fn ({1=x,...}:{1:int}) => x;
    val g' = fn () => f' {1=111};

(*******************)

(* Numeric labels in records *)
(** tuple unify record **)
val ({1=x,2=y}:int*int) = (34,21)  (* should bind x=34:int y=21:int *);
    
val ({1=x,...}:int*int) = (34,21)  (* should bind x=34 *);
    
val ({a=x,...}:int*int) = (32,34)  (* shouldn't type *);
    
val ({3=x,...}:int*int) = (32,34)  (* shouldn't type *);
    
val ({2=x,1=y,...}:int*int) = (34,21)  (* should bind x=34:int y=21:int *);
    
val ({1=x}:(int)) = 3              (* shouldn't type *);
    
     
    

fun f (x,y)     = x::y
  | f {1=x,2=y} = x::y      (* should bind f = fn : 'a * 'a list -> 'a list *);
    

fun f ({1=x,2=y}:'a*'a list) = x::y
  | f (x,y)     = x::y      (* should bind f = fn : 'a * 'a list -> 'a list *);
    
    
val f':'a * 'a list -> 'a list = f;
val f':{1:'a, 2:'a list} -> 'a list = f;
    
fun f (x,y)     = x::y
  | f {1=x,2=y} = x::y
  | f {1=x,2=y} = x::x::y;

val f = fn (x,y) => x::y | {1=x,...} => [x];
    
fun f (x,y)     = x::y
  | f {1=x,...} = [x]
  | f {1=x,2=y} = x::x::y;
   
datatype foo = F1 | F2 | F3 of foo;
    fun f {1=F3 x,...} = f (x,x)
      | f (F1,F1) = 0
      | f {2=F2,...} = 2
      | f {2=x,1=y} = if x=y then 1 else f (x,x);

map f [(F1,F1),(F2,F1),(F1,F2),(F3 F2,F1),(F3 (F3 F1),F3 F2)];
	
(*****)
(** record unify tuple **)

val ((x,y):{1:int,2:int}) = (34,21);
val ((x,y):{1:int,2:int}) = {1=11,2=22};
    

fun f {1=x,2=y} = x::y
  | f (x,y)     = x::y;
    
val f':'a * 'a list -> 'a list = f;
val f':{1:'a, 2:'a list} -> 'a list = f;
    
fun f ((x,y):{2:'a list,1:'a})     = x::y
  | f {1=x,2=y} = x::y;

fun f {1=x,...} = [x]
  | f (x,y)     = x::y
  | f {1=x,2=y} = x::x::y;
    
fun f {1=x,2=y} = x::x::y
  | f {1=x,...} = [x]
  | f (x,y)     = x::y;
    
    #1 (1,2,3);
    #3 (3,4,"dlsjf");
    #a (3,4);
    #0 (1);
    #1 (3);
    #4 (2,4);
    #~3 (3,4);
    
(***** bugs ***)
fun f p ({1=x,2=y}:int->int) =  p; (* shouldn't type *)
    
{1="Hello"};  (* shouldn't become a tuple *)

fun mangle x = {1=x};  (* should type to 'a -> { 1:'a } *)

if true then ("A", "B") else {1="A", 2="B"};

if true then {1="A", 2="B"} else ("A", "B");

{001="A"}; (* shouldn't parse *)

{1=0,2=0,3=0,4=0,5=0,6=0,7=0,8=0,9=0,10=0}; (* should type as tuple *)
