abstype 'a DYN = Dymamic of (int list * 'a Mapping * int)

with
    local
	infix  3 sub; 
	val {arrayoflist,sub,assign} = ESML_Array;
	    
	val Dyn = arrayoflist (listof 256 []);

	fun reset () =
	    let
		fun clear(n) = 
		    if n < 257 
			then (assign(Dyn,n,[]);clear(n+1))
		    else ()
	    in
		clear(1)
	    end;
				     
	val Curr = ref [];
	    
	    (*
	     * The main insertion function.
	     * 'l' is the list of needed op-codes
	     * 'f' is the list of options to be stored
	     *)

	fun option' l f = 
	    let
		val r = rev l;
		val n = (hd r) + 1;
		val x = Dyn sub n;
		val len = length r - 1;
	        val t = map (fn x => (r,x,len)) f;
	    in
		assign(Dyn,n,t@x)
	    end;
	
	fun usefun  a f = option' [a] (map FN [f]);
	fun prim    a f = option' [a] (map ANSWER [f]);
	fun option  a f = option'  a  (map FNL [f]);
	fun optprim a f = option'  a  (map ANSWER [f]);
	    
	fun Usefun  a f = option' [a] (map FN f);
	fun Prim    a f = option' [a] (map ANSWER f);
	fun Option  a f = option'  a  (map FNL f);
	fun Optprim a f = option'  a  (map ANSWER f);
	    
	fun NulifyDy () = (Curr := []);
	    
	fun FindDy (n) = 
	    
	    let
		val d_list = Dyn sub (n+1)
		fun zf x y z = (map x (filter y z));
		val _ = Curr := d_list@(!Curr);
		local
		    fun takeoff (_::l,f,i) = (l,f,i);
		    fun testequal (a::_,_,_) = a=n;
		in
		    val possible = zf takeoff testequal (!Curr);
		end;
		local
		    fun notnull (l,_,_) = not (null l);
		    fun isnull (l,_,_) = (null l);
		    fun ThreetoTwo ([],f,i) = (f,i);
		in
		    val _ = Curr := filter notnull possible;
		    val valid = zf ThreetoTwo isnull possible;
		end;
		val d = case d_list of
		    [] => (BCI,0)::valid   (* supply Byte code insertion *)
		  | _  => valid;
	    in
		if !(#PHCommon Ncopt) then d else [hd d] (* optional optz *)
	    end;
    in	    
	val DynamicDB = { prim = prim,
			 usefun = usefun,
			 option = option,
			 optprim = optprim,
			 Prim = Prim,
			 Usefun = Usefun,
			 Option = Option,
			 Optprim = Optprim,
			 NulifyDy = NulifyDy,
			 FindDy = FindDy,
			 reset = reset
			 }
    end

end;



(*
fun bla _ = ();

    prim 4 ();
    usefun 5 bla;
    option [3,4,5] bla;
    optprim [1,2,5] ();
    
Dyn sub 5;
Dyn sub 6;
*)


