import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.String;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EnumSet;
import java.util.HashMap;

public class Asm {
	enum Func {
		add, sub, inc, dec, and, or, xor;

		static HashMap<String, Integer> lut;
		static {
			lut = new HashMap<String, Integer>();
			for (Func f : EnumSet.allOf(Func.class)) {
				lut.put(f.name(), f.ordinal());
			}
		}
	}

	enum Rotate {
		nsh, rcy1(">>1"), rcy8(">>8"), rcy16(">>16");

		String label;
		static HashMap<String, Integer> lut = new HashMap<String, Integer>();

		Rotate(String s) {
			label = s;
		}

		Rotate() {
			label = null;
		}

		static {
			lut = new HashMap<String, Integer>();
			for (Rotate r : EnumSet.allOf(Rotate.class)) {
				if (r.label != null) {
					lut.put(r.label, r.ordinal());
				}
			}
		}
	}

	enum Skip {
		nsk, lez("?<0"), eqz("?==0"), inr("?in");

		String label;
		static HashMap<String, Integer> lut = new HashMap<String, Integer>();

		Skip(String s) {
			label = s;
		}

		Skip() {
			label = null;
		}

		static {
			lut = new HashMap<String, Integer>();
			for (Skip s : EnumSet.allOf(Skip.class)) {
				if (s.label != null) {
					lut.put(s.label, s.ordinal());
				}
			}
		}
	}

	enum Op {
		fun, std("->dm"), sti("->im"), out("->out"), ldd("<-dm"), in("<-in"), jmp(
				"jmp");

		String label;
		static HashMap<String, Integer> lut = new HashMap<String, Integer>();

		Op(String s) {
			label = s;
		}

		Op() {
			label = null;
		}

		static {
			lut = new HashMap<String, Integer>();
			for (Op o : EnumSet.allOf(Op.class)) {
				if (o.label != null) {
					lut.put(o.label, o.ordinal());
				}
			}
		}
	}

	static final String header = "DEPTH = 1024;                   -- The size of memory in words\n"
			+ "WIDTH = 32;                    -- The size of data in bits\n"
			+ "ADDRESS_RADIX = HEX;          -- The radix for address values\n"
			+ "DATA_RADIX = BIN;             -- The radix for data values\n"
			+ "CONTENT                       -- start of (address : data pairs)\n"
			+ "BEGIN\n\n";
	static final String footer = "\nEND;";

	public static FileWriter mifoutfile;
	public static FileWriter rmboutfile;
	static HashMap<String, Integer> label_lut = new HashMap<String, Integer>();

	static class LineParseException extends Exception {
		private static final long serialVersionUID = 1L;
	}

	public static String toNBitBinaryString(int number, int bits) {
		String full = Integer.toBinaryString(number);
		if (full.length() > bits) {
			return full.substring(full.length() - bits, full.length());
		} else {
			String zeros = "";
			int zeropad = bits - full.length();
			while (zeropad-- > 0)
				zeros += "0";
			return zeros + full;
		}
	}
	
	public static void writeNBitString(int number, int bits) throws IOException {
		String nbitstring = toNBitBinaryString(number, bits);
		mifoutfile.write(nbitstring);
		rmboutfile.write(nbitstring);
	}
	
	public static void doPass(String filename, boolean second) throws IOException, LineParseException {
		int addr = 0;
		int lineno = 0;
		String line = null;
		NumberFormat int_parser = NumberFormat.getIntegerInstance();
		FileReader infile = new FileReader(filename);
		BufferedReader in = new BufferedReader(infile);
		if (second) {
			String basename = filename.substring(0, filename.lastIndexOf("."));
			mifoutfile = new FileWriter(basename + ".mif");
			rmboutfile = new FileWriter(basename + ".rmb");
			mifoutfile.write(header);
		}
		try {
			while ((line = in.readLine()) != null) {
				if (line.startsWith("#"))
					continue;
				String tokens[] = line.split("(\\s|:|,)+", -1);
				int rw = 0;
				boolean lc = false;
				int ra = 0;
				int rb = 0;
				int func = Func.and.ordinal();
				int rot = 0;
				int skip = 0;
				int op = 0;
				int c = 0;
				int reg = 0;
				boolean write_inst = false;
				for (int i = 1; i < tokens.length; i++) {
					if (tokens[i].startsWith("#"))
						break;
					Integer func_ = Func.lut.get(tokens[i]);
					if (func_ != null) {
						func = func_;
						write_inst = true;
						continue;
					}
					Integer rot_ = Rotate.lut.get(tokens[i]);
					if (rot_ != null) {
						rot = rot_;
						write_inst = true;
						continue;
					}
					Integer skip_ = Skip.lut.get(tokens[i]);
					if (skip_ != null) {
						skip = skip_;
						write_inst = true;
						continue;
					}
					Integer op_ = Op.lut.get(tokens[i]);
					if (op_ != null) {
						op = op_;
						write_inst = true;
						continue;
					}
					if (tokens[i].startsWith("r")) {
						int regno;
						write_inst = true;
						try {
							regno = int_parser.parse(tokens[i].substring(1)).intValue();
						} catch (ParseException e) {
							System.err
									.println("Excepted register number, got \""
											+ tokens[i] + "\".");
							throw new LineParseException();
						}
						switch (reg) {
							case 0: // fall through
								rw = regno;
							case 1:
								ra = regno;
							case 2:
								rb = regno;
								break;
							default:
								System.err.println("Too many registers specified.");
								throw new LineParseException();
						}
						reg++;
						continue;
					}
					if (tokens[i].equals("lc")) {
						lc = true;
						write_inst = true;
						continue;
					}
					if (lc) {
						try {
							c = int_parser.parse(tokens[i]).intValue();
							continue;
						} catch (ParseException e) {
							Integer c_ = label_lut.get(tokens[i]);
							if (c_ != null) {
								c = c_;
								continue;
							}
						}
					}
					if (tokens[i].equals("")) {
						break;
					} else {
						if (!second) break;
						System.err.println("Unrecognised token \"" + tokens[i] + "\".");
						throw new LineParseException();
					}
				}
				if (!second && tokens[0].length() > 0 && !tokens[0].contains("#"))
					label_lut.put(tokens[0], addr);
				if (write_inst) {
					if (second) {
						mifoutfile.write(Integer.toHexString(addr));
						mifoutfile.write(" : ");
						writeNBitString(rw, 7);
						if (lc) {
							writeNBitString(1, 1);
							writeNBitString(c, 24);
						} else {
							writeNBitString(0, 1);
							writeNBitString(ra, 7);
							writeNBitString(rb, 7);
							writeNBitString(func, 3);
							writeNBitString(rot, 2);
							writeNBitString(skip, 2);
							writeNBitString(op, 3);
						}
						mifoutfile.write(";\n");
						rmboutfile.write("\n");
					}
					addr++;
				}
				lineno++;
			}
			if (second) {
				for (;addr<1024;addr++) {
					mifoutfile.write(Integer.toHexString(addr));
					mifoutfile.write(" : ");
					writeNBitString(0, 32);
					mifoutfile.write(";\n");
					rmboutfile.write("\n");
				}
				mifoutfile.write(footer);
				mifoutfile.close();
				rmboutfile.close();
			}
		} catch (LineParseException e) {
			System.err.println("Error with instruction \"" + line
					+ "\" at line " + lineno + " (address " + addr + "). Didn't understand.");
			throw e;
		}
	}

	public static void main(String[] args) throws IOException {
		try {
			doPass(args[0], false);
			doPass(args[0], true);
		}  catch (LineParseException e) {
			System.out.println("Failure");
			return;
		}
		System.out.println("Success");
	}
}