// $Id: $
// djip: DMA controller.
//

// This is a single channel DMA controller

// It only does block copies: a more advanced device would service
// a linked list of buffers in main RAM.
#ifndef dram_H
#define dram_H

#define TRC(X) X
#define ROWS 1024
#define COLS 1024
#define CAPACITY ROWS*COLS
class dram_bev_model
{
 public:
  uint32 *data[ROWS]; 

  int row_address;

  void row_address_latch(uint32 ma) { row_address = ma; }

  void dram_write(sc_uint<10> a, uint32 d) 
  { 
    uint32 *row = data[row_address];
    if (!row)
      {
	row = (uint32 *)malloc(sizeof(uint32) * COLS);
	data[row_address ] = row;
      }
    row[(int)a] = d;
  }

  uint32 dram_read(sc_uint<10> a) 
  { 
    uint32 *row = data[row_address];
    if (!row) return 0;
    else return row[(int)a]; // This is a CAS access time of one clock cycle - 2..3 is more realistic.
  }


  // Constructor
  dram_bev_model()
    {
      for (int i=0; i<1024; i++) data[i] = 0;
    }

};



class dram_net_level: public sc_module, public dram_bev_model
{
 public:
  sc_in <bool> rst;          // 
  sc_in <bool> clk;          // 
  sc_in <bool> ras_n;        // Row address strobe (active low)
  sc_in <bool> cas_n;        // Column address strobe (active low)
  sc_in <bool> we_n;         // Write enable (active low)

  sc_in <sc_uint<10> >  ma;  // Multiplexed address
  sc_in <uint32>  wdata;         // Write Data
  sc_out <uint32> rdata;         // Read Data


  bool ras_prev;
  int ras_recovery;  // Used to model writeback time after a row is closed.

#define RECOVERY_TICKS 2

  void target_behaviour()
  {
    if (!ras_n.read())
      {
	if (!ras_prev) 
	  {
	    if (ras_recovery < RECOVERY_TICKS) printf("%s: RAS cycle started before precharge/writeback complete", name());
	    row_address_latch(ma.read());
	  }
	ras_recovery = 0;
      }

    if (ras_n.read() && ras_recovery < RECOVERY_TICKS) ras_recovery += 1;

    if (!cas_n.read())
      {
	if (we_n.read()) rdata = dram_read(ma);
	else dram_write(ma, wdata);
      }

    ras_prev = ras_n.read();
  }


  void hw_reset()
  {
    ras_recovery = 0;
    ras_prev = true;
  }

  SC_HAS_PROCESS(dram_net_level);
   dram_net_level(sc_module_name name) : 
   sc_module(name), 
   dram_bev_model()
  {
    SC_METHOD(target_behaviour); sensitive << clk.pos(); 
  }

};

#endif
// eof
