// $Id: $
// The nominal processor core wrapped up as a SystemC component with transactors installed to call to an RTL-style bus model.
//
#ifndef NOMINALPROC_RTL_H
#define NOMINALPROC_RTL_H

#include "nominalproc_iss.h"


// This component inherits the nominal processor ISS (instruction set simulator).

class nominalproc_rtl : public nominalproc_iss, public sc_module
{
  public:

  sc_in <bool> rst, clk, irq;
  
  sc_out <uint32> addr, wdata;
  sc_in <uint32> rdata;
  sc_out <bool> hren, hwen;
  sc_in <bool> opack;

#define Q(X, Y) printf("%s: %s %X\n", name(), X, Y)

  int codefetch(int a)  // Transactor: ESL target, net-side initiator. 
  {
    Q("fetch code from ", a);
    addr = a; hwen = 0; hren = 1;
    do { wait(clk.posedge_event()); } while (!opack.read());
    int r = rdata.read();
    //Q("fetched code ", r);
    hren = 0;
    return r;
  }

  int datafetch(int a)
  {
    // Map code and data spaces to one. No separate I-cache or Harvard-like features! 
    return codefetch(a);
  }


  void datawrite(int a, int d)   // Transactor: ESL target, net-side initiator. 
  {
    printf("%s Datawrite A=0x%08X  D=0x%08x\n", name(), a, d);
    addr = a; hwen = 0; hren = 1; wdata = d;
    do { wait(clk.posedge_event()); } while (!opack.read());
    hren = 0;
  }


  void clkme()
  {
    while(1)
      {
	wait(clk.posedge_event());
	if (rst.read()) reset();
	else if (irq.read() && !interrupted) 
	  {
	    interrupt();
	    printf("iss: %s IRQ\n", name());
	  }
	else if (runhaltb) step();
      }
  }

  SC_CTOR(nominalproc_rtl)
  {
    SC_THREAD(clkme);
  }
};

#endif
// eof
