// $Id: $
// djip: cache.h
//


#ifndef cache_H
#define cache_H

#define TRC(X) X

class cache_bev_model
{
 public:
  int ways, total, lru;

  uint32 **tag, **data;

  virtual uint initiator_busread(uint a) = 0;
  virtual void initiator_buswrite(uint a, uint d) = 0;


  void cache_write(uint a, uint32 d) 
  { 
    int m = (a>>2) % (total/ways);
    int w = lru;
    lru = (lru +1) % ways;
    tag[w][m] = a;
    data[w][m] = d;
  }

  uint32 target_read(uint a) 
  { 
    int m = (a>>2) % (total/ways);
    int w;
    for (w=0;w<ways;w++) if (tag[w][m] == a) break;
    if (w<ways) return data[w][m];
    int d = initiator_busread(a);
    cache_write(a, d);
    return d;
  }


  void target_write(uint a, uint32 d) 
  { 
    cache_write(a, d);
    initiator_buswrite(a, d);
  }



  void invalidate_all()
  {
    for (int i=0;i<ways;i++) for (int j=0;j<total;j++) tag[i][j] = 1; // an illegal address
  }

  void reset()
  {
    lru = 0;
    invalidate_all();
  }

  // Constructor
 cache_bev_model(int ways, int total) :ways(ways), total(total)
    {
      for (int w=0; w<ways; w++) 
	{
	  tag[w]  = (uint32 *)malloc(sizeof(uint32) * total/ways);
	  data[w] = (uint32 *)malloc(sizeof(uint32) * total/ways);
	}
      reset();
    }

};



class cache_net_level: public sc_module, public cache_bev_model
{
 public:
  sc_in <bool> rst, clk;

  // Slave/target net-level port (e.g. for CPU to connect to)
  sc_in <uint32> addr, wdata;
  sc_out <uint32> rdata;
  sc_in <bool> hren, hwen;
  sc_out <bool> opack;

  // Master/initiator net-level port: (e.g. to connect to DRAM controller)
  sc_out <uint32> m_addr, m_wdata;
  sc_in <uint32> m_rdata;
  sc_out <bool> m_hren, m_hwen;
  sc_in <bool> m_opack;



  void behaviour()
  {
    while (1)
      {
	wait(clk.posedge_event());
	if (hren.read() && hwen.read()) 
	  rdata = /*bevmodel.*/target_read(addr.read()/4);
	else
	  if (hren.read() && !hwen.read()) 
	    /*bevmodel.*/target_write(addr.read()/4, wdata.read()/4);
      }
  }



  uint initiator_busread(uint a)  // Net-level bus read initiator
  {
    TRC(printf("%s fetch code from A=0x%08X", name(), a));
    m_addr = a; m_hwen = 0; m_hren = 1;
    do { wait(clk.posedge_event()); } while (!m_opack.read());
    int r = m_rdata.read();
    m_hren = 0;
    return r;
  }


  void initiator_buswrite(uint a, uint d)   // Net-level bus write initiator
  {
    TRC(printf("%s Datawrite A=0x%08X  D=0x%08x\n", name(), a, d));
    m_addr = a; m_hwen = 1; m_hren = 0; m_wdata = d;
    do { wait(clk.posedge_event()); } while (!m_opack.read());
    m_hwen = 0;
  }



  void hw_reset()
  {
    reset();
  }

  // Constructor
  SC_HAS_PROCESS(cache_net_level);
 cache_net_level(sc_module_name name, int ways, int total) : sc_module(name), cache_bev_model(ways, total)
    {
    reset();
    SC_THREAD(behaviour);
    SC_METHOD(hw_reset); sensitive << clk.pos(); 
    }

};

#endif
// eof
