// SoCDAM Course Nominal Processor:   (C) DJ Greaves, 2009.  
// $Id: $
// 
// 
//
// This file contains a SystemC testbench for a single CPU and two RAM banks.


#define uint32 unsigned int
// Perhaps instead defined as sc_uint<32> ?


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "systemc.h"
#include "djip/nominalproc_rtl.h"
#include "djip/clock100.h"
#include "djip/ram32.h"
#include "djip/busmux.h"
#include "djip/addr_decode.h"
#include "djip/dma_controller.h"
#include "djip/bus_bridge.h"
#include "djip/bus_combiner.h"


sc_trace_file *g_tf = 0;

ASM test_program[] = 
  {
    { "start", ORG,  0, 0, "Reset to here" },
    { "io_base", EQU,  0x20000, 0, "Output device" },
    { 0,      JMP,  L(enter), 0, "" },
    { "unity", DEFW,  1, 0, "" },


    { "enter", LOAD,  R1, L(unity), "" },
    { "loop",  ADD,  R1, R1, "Double until wraps to zero" },
    { "",      STORE,  R1, L(io_base), "" },
    { "",      BNZ,  R1, L(loop), "" },
    { "",      HALT, 0, 0, "" },
    { "",      END,  0, 0, "" } // Terminate end of program

  }
;
 

//
// A processor nominal unit with a DMA controller and a RAM. 
//
SC_MODULE(DMA_EXAMPLE_SYSTEM)
{
  assembler *A;
  uint32 MAX, *code;

  sc_in <bool> rst, clk;

  // First initiator, nominal processor (A)
  sc_signal <bool>  hren_A, hwen_A;
  sc_signal <bool>   opack_A;
  sc_signal <uint32> rdata_A;
  sc_signal <uint32> addr_A, wdata_A;

  // Second initiator, DMA unit (B): 
  sc_signal <bool>  hren_B, hwen_B;
  sc_signal <bool>   opack_B;
  sc_signal <uint32> rdata_B;
  sc_signal <uint32> addr_B, wdata_B;

  
  // Combined output signals
  sc_signal <bool>  hren_C, hwen_C;
  sc_signal <bool>   opack_C;
  sc_signal <uint32> rdata_C;
  sc_signal <uint32> addr_C, wdata_C;

  // Demultiplexed signals to individual targets
  sc_signal <uint32> rdata0, rdata1;
  sc_signal <bool> hren0, hren1;
  sc_signal <bool> hwen0, hwen1;
  sc_signal <bool> opack0, opack1;
  
  sc_signal <bool> irq;

  void traceme(sc_trace_file *tf)
  {
#define VCD(X)  sc_trace(g_tf, X, #X);
    VCD(clk);  VCD(rst);
    VCD(irq);  VCD(addr_C); 
    VCD(hwen_C); 
    VCD(wdata_C);   VCD(rdata_C);
    VCD(hren_C); 
    VCD(opack_C);
  }
  
  nominalproc_rtl          nominal_0;
  DMA_CONTROLLER_net_level dma_controller_0;
                    busmux busmux_0;
               addr_decode addr_decode_0;
                     ram32 code_memory_0;
  // Bus combiner - containing arbiter - to combine their outputs
  bus_combiner combiner0;


  SC_CTOR(DMA_EXAMPLE_SYSTEM) :
    
    nominal_0("nominal_0"),
    dma_controller_0("dma_controller_0"),
    busmux_0("busmux_0"),
    addr_decode_0("addr_decode_0"),
    code_memory_0("code_memory_0"),
    combiner0("combiner_0")
      {
	nominal_0.rst(rst); // Initiator port
	nominal_0.clk(clk);
	nominal_0.irq(irq);
	nominal_0.hren(hren_A);
	nominal_0.opack(opack_A);
	nominal_0.rdata(rdata_A);
	nominal_0.wdata(wdata_A);
	nominal_0.addr(addr_A);
	nominal_0.hwen(hwen_A);
	
	dma_controller_0.rst(rst); // Initiator port
	dma_controller_0.clk(clk);
	dma_controller_0.m_hren(hren_B);
	dma_controller_0.m_opack(opack_B);
	dma_controller_0.m_rdata(rdata_B);
	dma_controller_0.m_wdata(wdata_B);
	dma_controller_0.m_addr(addr_B);
	dma_controller_0.m_hwen(hwen_B);

  
	// Combiner for initiators
	combiner0.clk(clk);
	combiner0.rst(rst);

	combiner0.hwen_l0(hwen_A);
	combiner0.hren_l0(hren_A);
	combiner0.addr_l0(addr_A);
	combiner0.opack_l0(opack_A);
	combiner0.wdata_l0(wdata_A);
	combiner0.rdata_l0(rdata_A);
	
	combiner0.hwen_l1(hwen_B);
	combiner0.hren_l1(hren_B);
	combiner0.addr_l1(addr_B);
	combiner0.opack_l1(opack_B);
	combiner0.wdata_l1(wdata_B);
	combiner0.rdata_l1(rdata_B);

	// Output of combiner
	combiner0.hwen_r(hwen_C);
	combiner0.hren_r(hren_C);
	combiner0.addr_r(addr_C);
	combiner0.opack_r(opack_C);
	combiner0.wdata_r(wdata_C);
	combiner0.rdata_r(rdata_C);
    


	// Target address space resourcs now follow
#define SPLIT_POINT	 0x10000
	addr_decode_0.threshold = SPLIT_POINT;
	addr_decode_0.yr0(hren0);
	addr_decode_0.yr1(hren1);
	addr_decode_0.yw0(hwen0);
	addr_decode_0.yw1(hwen1);
	addr_decode_0.gr(hren_C);
	addr_decode_0.gw(hwen_C);
	addr_decode_0.addr(addr_C);

	busmux_0.threshold = SPLIT_POINT;
	busmux_0.in0(rdata0);
	busmux_0.in1(rdata1);
	busmux_0.opack0(opack0);
	busmux_0.opack1(opack1);
	busmux_0.y(rdata_C);
	busmux_0.opack(opack_C);
	busmux_0.addr(addr_C);
	
	code_memory_0.opack(opack0); // SRAM memory target port
	code_memory_0.rdata(rdata0);
	code_memory_0.hren(hren0);
	code_memory_0.hwen(hwen0);
	code_memory_0.rst(rst);
	code_memory_0.clk(clk);
	code_memory_0.wdata(wdata_C);
	code_memory_0.addr(addr_C);

    
  
	dma_controller_0.irq(irq);  // DMA unit target port
	dma_controller_0.hren(hren1);
	dma_controller_0.opack(opack1);
	dma_controller_0.rdata(rdata1);
	dma_controller_0.wdata(wdata_C);
	dma_controller_0.addr(addr_C);
	dma_controller_0.hwen(hwen1);
	
	MAX = 128;
	uint32 *code = (uint32 *) malloc(MAX * sizeof(uint32));
	A = new assembler(code, MAX); 
	A->assemble(name(), test_program);
    
	code_memory_0.contents(code, MAX);

	VCD(hren_A); VCD(hwen_A); VCD(opack_A);
	VCD(rdata_A); VCD(addr_A); VCD(wdata_A); VCD(hwen_A);
	VCD(hren_B); VCD(hwen_B); VCD(opack_B);
	VCD(rdata_B); VCD(addr_B); VCD(wdata_B); VCD(hwen_B);
	
	
      }

};

int main()
{
  g_tf = sc_create_vcd_trace_file("trace");
  g_tf->set_time_unit(1, SC_NS);
  sc_signal<bool> clk, rst;
  clock100 u_clkgen("u_clkgen");
  u_clkgen.clk(clk);


  DMA_EXAMPLE_SYSTEM *toplevel = new DMA_EXAMPLE_SYSTEM("DMA_EXAMPLE_SYSTEM0");
  toplevel->clk(clk);
  toplevel->rst(rst);

  rst = 1; 
  sc_start(100, SC_NS);
  rst = 0;
  printf("End of reset\n");
  sc_start(25, SC_US);

    

  cout << "Dual CPU SystemC nominal proc finished at " << sc_time_stamp() << "\n";
  sc_close_vcd_trace_file(g_tf);
  return 0;
}


// eof
