// $Id: $
// djip: tlmram32.h
// A simple 32 bit wide memory without bus lanes. Low two address bits ignored.
// Nominal TLM version!

#ifndef TLMRAM32_H
#define TLMRAM32_H

#include "djip/nominal_tlm.h"

class tlmram32 : public memport_if, public sc_module
{
 public:
  uint32 *memory, msize_words;

  // Allocate contents from an external buffer or locally.
  void add_contents(uint32 *c0)
  {
    // Generally use a hashmap instead of this simple malloc (as per TLM2 example).
    memory = c0 ? c0 : (uint32 *)(malloc(msize_words * sizeof(int)));
  }




  void b_transact(MEMPAYLOAD *p, sc_time &delay)
  {
    if (!memory) add_contents(0);
    delay += sc_time(2, SC_NS);
    if (p->rwbar)
      {
	p->data = memory[(p->addr/4) % msize_words];
	printf("%s read data [0x%x] := 0x%x\n", name(), p->addr, p->data);
      }
    else
      {
	printf("%s write data [0x%x] := 0x%x\n", name(), p->addr, p->data);
	memory[(p->addr/4) % msize_words] = p->data;
      }
  }
  
  // Constructor:
 tlmram32(const char *name, int msize_words) :
  sc_module(name),
  msize_words(msize_words)
  {

  }

};


// eof

#endif
