// $Id: $
// djip: ram32.h
// A simple 32 bit wide synchronous static RAM memory without bus lanes. Low two address bits ignored.

#ifndef RAM32_TRC
#define RAM32_TRC(X) X
#endif

SC_MODULE(ram32)
{
  uint32 *memory, msize_words;

  sc_in <bool> rst, clk;
  sc_in <uint32> addr, wdata;
  sc_out <uint32> rdata;
  sc_in <bool> hren, hwen;
  sc_out <bool> opack;


  // Allocate contents from an external buffer or locally.
  void contents(uint32 *c0, uint32 msize_words0)
  {
    msize_words = msize_words0;
    // Generally use a hashmap instead of this simple malloc (as per TLM2 example).
    memory = c0 ? c0 : (uint32 *)(malloc(msize_words * sizeof(int)));
  }

  void clkme()
  {
    if (hren.read())
      {
	rdata = memory[(addr.read()/4) % msize_words];
	RAM32_TRC(printf("%s  read from address %08X\n", name(), addr.read()));
	opack = 1;
      }
    else if (hwen.read())
      {
	RAM32_TRC(printf("%s write data [0x%x] := 0x%x\n", name(), addr.read(), wdata.read()));
	memory[(addr.read()/4) % msize_words] = wdata.read();
	opack = 1;
      }
    else opack = 0;

  }

  SC_CTOR(ram32)
  {
    // Synchronous RAM - takes one clock cycle to deliver a value.
    SC_METHOD(clkme); sensitive << clk.pos(); 

  }
};


// eof
