// $Id: $
// djip: bus bridge - RTL style coding.
//
#ifndef BUS_BRIDGE 
#define BUS_BRIDGE 

// This is a simplex bridge, so use two back-to-back for a duplex bridge.

// This bus bridge : commands go from left to right.
SC_MODULE(bus_bridge)
{
  sc_in <bool> rst, clk;

  // LHS port : target
  sc_in <uint32> addr_l, wdata_l;
  sc_out <uint32> rdata_l;
  sc_in <bool> hwen_l, hren_l;
  sc_out <bool> opack_l;

  // RHS port : initiator
  sc_out <uint32> addr_r, wdata_r;
  sc_in <uint32> rdata_r;
  sc_out <bool> hwen_r, hren_r;
  sc_in <bool> opack_r;

  void process()
  {
    hwen_r = 0;
    while (1)
      {
	wait(clk.posedge_event());
	if (hwen_l.read() || hren_l.read())
	  {
	    addr_r = addr_l.read();
	    hren_r = hren_l.read();
	    hwen_r = hwen_l.read();
	    wdata_r = wdata_l.read();
	    do { wait(clk.posedge_event()); } while (!opack_r.read());
	    rdata_l = rdata_r.read();
	    hwen_r = 0;
	    hren_r = 0;
	    opack_l = 1;
	    do { wait(clk.posedge_event()); } while (opack_r.read());
	    opack_l = 0;
	  }
      }
  }

  SC_CTOR(bus_bridge)
  {
    SC_THREAD(process);
  }

};

#endif
// eof
