// SoCDAM Course Nominal Processor:   (C) DJ Greaves, 2009.  
// $Id: $
// 
// 
//
// This file contains a SystemC testbench for a single CPU and two RAM banks.


#define uint32 unsigned int
// Perhaps instead defined as sc_uint<32> ?


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "systemc.h"
#include "djip/nominalproc_rtl.h"
#include "djip/clock100.h"
#include "djip/ram32.h"
#include "djip/busmux.h"
#include "djip/addr_decode.h"
#include "djip/dma_controller.h"
#include "djip/bus_bridge.h"
#include "djip/bus_combiner.h"
#include "djip/cache.h"
#include "djip/dram.h"
#include "djip/dram_controller.h"


sc_trace_file *g_tf = 0;

ASM test_program[] = 
  {
    { "start", ORG,  0, 0, "Reset to here" },
    { "io_base", EQU,  0x20000, 0, "Output device" },
    { 0,      JMP,  L(enter), 0, "" },
    { "unity", DEFW,  1, 0, "" },


    { "enter", LOAD,  R1, L(unity), "" },
    { "loop",  ADD,  R1, R1, "Double until wraps to zero" },
    { "",      STORE,  R1, L(io_base), "" },
    { "",      BNZ,  R1, L(loop), "" },
    { "",      HALT, 0, 0, "" },
    { "",      END,  0, 0, "" } // Terminate end of program

  }
;
 

//
// A processor nominal unit with local instruction RAM.
//
SC_MODULE(nominalunit)
{
  assembler *A;
  uint32 MAX, *code;


  sc_in <bool> rst, clk, irq;

  // Bus master port
  sc_in <bool>  opack1;
  sc_in <uint32> rdata1;
  sc_out  <uint32> addr, wdata;
  sc_out <bool>  hren1, hwen1;

  // Local signals

  sc_signal <uint32> rdata, rdata0;
  sc_signal <bool> hren, hren0;
  sc_signal <bool> hwen, hwen0;
  sc_signal <bool> opack, opack0;


  void traceme(sc_trace_file *tf)
  {
#define VCD(X)  sc_trace(g_tf, X, #X);
    VCD(clk);  VCD(rst);
    VCD(irq);  VCD(addr); 
    VCD(hwen);     VCD(hwen0);
    VCD(wdata);   VCD(rdata);
    VCD(hren);  VCD(hren0);
    VCD(opack);  VCD(opack0);
  }

  nominalproc_rtl *nominal_0;
           busmux *busmux_0;
      addr_decode *addr_decode_0;
            ram32 *code_memory_0;


  SC_CTOR(nominalunit)
  {

            nominal_0 = new nominalproc_rtl("nominal_0");
             busmux_0 = new busmux("busmux_0");
        addr_decode_0 = new addr_decode("addr_decode_0");
        code_memory_0 = new ram32("code_memory_0");
    
    nominal_0->rst(rst);
    nominal_0->clk(clk);
    nominal_0->irq(irq);
    nominal_0->hren(hren);
    nominal_0->opack(opack);
    nominal_0->rdata(rdata);
    nominal_0->wdata(wdata);
    nominal_0->addr(addr);
    nominal_0->hwen(hwen);
  
  
    busmux_0->threshold = 0x10000;
    busmux_0->in0(rdata0);
    busmux_0->in1(rdata1);
    busmux_0->opack0(opack0);
    busmux_0->opack1(opack1);
    busmux_0->y(rdata);
    busmux_0->opack(opack);
    busmux_0->addr(addr);
    


    addr_decode_0->threshold = 0x10000;
    addr_decode_0->yr0(hren0);
    addr_decode_0->yr1(hren1);
    addr_decode_0->yw0(hwen0);
    addr_decode_0->yw1(hwen1);
    addr_decode_0->gr(hren);
    addr_decode_0->gw(hwen);
    addr_decode_0->addr(addr);
    

    MAX = 128;
    uint32 *code = (uint32 *) malloc(MAX * sizeof(uint32));
    A = new assembler(code, MAX); 
    A->assemble(name(), test_program);
    
    code_memory_0->contents(code, MAX);
    
    code_memory_0->opack(opack0);
    code_memory_0->rdata(rdata0);
    code_memory_0->hren(hren0);
    code_memory_0->rst(rst);
    code_memory_0->clk(clk);
    code_memory_0->wdata(wdata);
    code_memory_0->addr(addr);
    code_memory_0->hwen(hwen);
    

  }

};


SC_MODULE(dual_node)
{

  sc_in <bool> clk, rst;

  // First processor unit (A): 
  sc_signal <bool>  hren_A, hwen_A, irq_A;
  sc_signal <bool>   opack_A;
  sc_signal <uint32> rdata_A;
  sc_signal <uint32> addr_A, wdata_A;
  nominalunit nominalunit_A;



  // Second processor unit (B): 
  sc_signal <bool>  hren_B, hwen_B, irq_B;
  sc_signal <bool>   opack_B;
  sc_signal <uint32> rdata_B;
  sc_signal <uint32> addr_B, wdata_B;
  nominalunit nominalunit_B;
  


  // Bus combiner - containing arbiter - to combine their outputs
  // Combined output signals
  sc_signal <bool>  hren_C, hwen_C, irq_C;
  sc_signal <bool>   opack_C;
  sc_signal <uint32> rdata_C;
  sc_signal <uint32> addr_C, wdata_C;
  bus_combiner combiner0;


  sc_signal <bool>  hren_dram, hwen_dram;
  sc_signal <bool>   opack_dram;
  sc_signal <uint32> rdata_dram;
  sc_signal <uint32> addr_dram, wdata_dram;

  // Cache and DRAM
  cache_net_level cache0;
  dram_controller dram_controller0;
  dram_net_level dram0;

  sc_signal <bool> dr_ras_n, dr_cas_n, dr_we_n;
  sc_signal <uint32>  dr_rdata, dr_wdata;
  sc_signal <sc_uint<10> >  dr_ma;

  SC_CTOR(dual_node) : 
    nominalunit_A("nominalunit_A"),
    nominalunit_B("nominalunit_B"),
    combiner0("combiner_0"),
    cache0("cache0", 4, 256),
    dram_controller0("dram_controller0"),
    dram0("dram0")
  {
    nominalunit_A.clk(clk);
    nominalunit_A.rst(rst);
    nominalunit_A.irq(irq_A);
    nominalunit_A.hwen1(hwen_A);
    nominalunit_A.hren1(hren_A);
    nominalunit_A.opack1(opack_A);
    nominalunit_A.wdata(wdata_A);
    nominalunit_A.addr(addr_A);
    nominalunit_A.rdata1(rdata_A);

  VCD(hren_A); VCD(hwen_A); VCD(opack_A); VCD(irq_A);
  VCD(rdata_A); VCD(addr_A); VCD(wdata_A); VCD(hwen_A);

    nominalunit_B.clk(clk);
    nominalunit_B.rst(rst);
    nominalunit_B.irq(irq_B);
    nominalunit_B.hwen1(hwen_B);
    nominalunit_B.hren1(hren_B);
    nominalunit_B.opack1(opack_B);
    nominalunit_B.wdata(wdata_B);
    nominalunit_B.addr(addr_B);
    nominalunit_B.rdata1(rdata_B);
    nominalunit_B.traceme(g_tf);


    VCD(hren_B); VCD(hwen_B); VCD(opack_B); VCD(irq_B);
    VCD(rdata_B); VCD(addr_B); VCD(wdata_B); VCD(hwen_B);

    combiner0.clk(clk);
    combiner0.rst(rst);
    combiner0.hwen_l0(hwen_A);
    combiner0.hren_l0(hren_A);
    combiner0.addr_l0(addr_A);
    combiner0.opack_l0(opack_A);
    combiner0.wdata_l0(wdata_A);
    combiner0.rdata_l0(rdata_A);

    combiner0.hwen_l1(hwen_B);
    combiner0.hren_l1(hren_B);
    combiner0.addr_l1(addr_B);
    combiner0.opack_l1(opack_B);
    combiner0.wdata_l1(wdata_B);
    combiner0.rdata_l1(rdata_B);


    combiner0.hwen_r(hwen_C);
    combiner0.hren_r(hren_C);
    combiner0.addr_r(addr_C);
    combiner0.opack_r(opack_C);
    combiner0.wdata_r(wdata_C);
    combiner0.rdata_r(rdata_C);

    // The combiner generates cycles on the cached dram.
    cache0.clk(clk);
    cache0.rst(rst);
    cache0.hwen(hwen_C);
    cache0.hren(hren_C);
    cache0.addr(addr_C);
    cache0.wdata(wdata_C);
    cache0.rdata(rdata_C);
    cache0.opack(opack_C);


    cache0.m_hwen(hwen_dram); // Backside of cache - connects to DRAM controller.
    cache0.m_hren(hren_dram);
    cache0.m_addr(addr_dram);
    cache0.m_wdata(wdata_dram);
    cache0.m_rdata(rdata_dram);
    cache0.m_opack(opack_dram);

    dram_controller0.hwen(hwen_dram);
    dram_controller0.hren(hren_dram);
    dram_controller0.addr(addr_dram);
    dram_controller0.wdata(wdata_dram);
    dram_controller0.rdata(rdata_dram);
    dram_controller0.opack(opack_dram);


    dram_controller0.dr_ras_n(dr_ras_n);
    dram_controller0.dr_cas_n(dr_cas_n);
    dram_controller0.dr_we_n(dr_we_n);
    dram_controller0.dr_ma(dr_ma);
    dram_controller0.dr_rdata(dr_rdata);
    dram_controller0.dr_wdata(dr_wdata);


    dram0.clk(clk);
    dram0.rst(rst);
    dram0.ras_n(dr_ras_n);
    dram0.cas_n(dr_cas_n);
    dram0.we_n(dr_we_n);
    dram0.ma(dr_ma);
    dram0.rdata(dr_rdata);
    dram0.wdata(dr_wdata);


    irq_A  = 0;
    irq_B  = 0;

  }





};

int main()
{
  g_tf = sc_create_vcd_trace_file("trace");
  g_tf->set_time_unit(1, SC_NS);
  sc_signal<bool> clk, rst;
  clock100 u_clkgen("u_clkgen");
  u_clkgen.clk(clk);


  dual_node *toplevel = new dual_node("dual_node");
  toplevel->clk(clk);
  toplevel->rst(rst);

  rst = 1; 
  sc_start(100, SC_NS);
  rst = 0;
  printf("End of reset\n");
  sc_start(5, SC_US);

    
  toplevel->irq_B = 1;
  cout << ("Interrupt to B\n") << sc_time_stamp() << "\n";
  sc_start(10, SC_US);

  cout << "Dual CPU SystemC nominal proc finished at " << sc_time_stamp() << "\n";
  sc_close_vcd_trace_file(g_tf);
  return 0;
}


// eof
